/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class ScreenFileObjectListener
implements FileChangeListener {
    private WeakReference<DesignComponent> component;
    private WeakReference<DesignComponent> imageComponent;
    private String propertyName;

    public ScreenFileObjectListener(DesignComponent component, DesignComponent imageComponent, String propertyName) {
        assert (component != null);
        assert (imageComponent != null);
        this.component = new WeakReference<DesignComponent>(component);
        this.imageComponent = new WeakReference<DesignComponent>(imageComponent);
        this.propertyName = propertyName;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        this.changeResourcePath(fe.getFile());
        this.reload();
    }

    public void fileDeleted(FileEvent fe) {
        this.changeResourcePath(fe.getFile());
        this.reload();
        fe.getFile().removeFileChangeListener((FileChangeListener)this);
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.changeResourcePath(fe.getFile());
        this.reload();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.changeResourcePath(fe.getFile());
        this.reload();
    }

    private ScreenDeviceInfo getScreenDeviceInfo() {
        if (this.component == null || this.component.get() == null) {
            return null;
        }
        DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
        if (document == null) {
            return null;
        }
        ScreenDeviceInfoPresenter dip = (ScreenDeviceInfoPresenter)document.getRootComponent().getPresenter(ScreenDeviceInfoPresenter.class);
        if (dip != null) {
            return dip.getScreenDeviceInfo();
        }
        return null;
    }

    private void reload() {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ScreenDeviceInfo deviceInfo = ScreenFileObjectListener.this.getScreenDeviceInfo();
                if (deviceInfo != null) {
                    ScreenDisplayPresenter presenter = (ScreenDisplayPresenter)((DesignComponent)ScreenFileObjectListener.this.component.get()).getPresenter(ScreenDisplayPresenter.class);
                    presenter.reload(deviceInfo);
                }
            }
        });
    }

    private void changeResourcePath(FileObject fo) {
        if (this.component == null || this.component.get() == null || ((DesignComponent)this.component.get()).getDocument() == null) {
            return;
        }
        Map<FileObject, String> fileMap = MidpProjectSupport.getAllFilesForProjectByExt(((DesignComponent)this.component.get()).getDocument(), Arrays.asList(fo.getExt()));
        final String path = fileMap.get(fo);
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
        document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (ScreenFileObjectListener.this.propertyName != null && path != null) {
                    ((DesignComponent)ScreenFileObjectListener.this.imageComponent.get()).writeProperty(ScreenFileObjectListener.this.propertyName, MidpTypes.createStringValue(path));
                } else if (ScreenFileObjectListener.this.propertyName != null) {
                    ((DesignComponent)ScreenFileObjectListener.this.imageComponent.get()).writeProperty(ScreenFileObjectListener.this.propertyName, PropertyValue.createNull());
                }
            }
        });
    }
}

