/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.usercode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.ActionFactory;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.CodeUtils;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class PropertyEditorUserCode
extends DesignPropertyEditor
implements PropertyEditorMessageAwareness {
    public static final PropertyValue NULL_VALUE = PropertyValue.createNull();
    public static final String NULL_TEXT = NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_STRING_NULL");
    public static final String USER_CODE_TEXT = NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_STRING_USER_CODE");
    private static final Icon ICON_WARNING = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/warning.gif", (boolean)false);
    private static final Icon ICON_ERROR = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/error.gif", (boolean)false);
    private CustomEditor customEditor;
    private JRadioButton userCodeRadioButton;
    private JLabel messageLabel;
    private String userCodeLabel;
    private String userCode = "";
    protected WeakReference<DesignComponent> component;
    private LinkedHashMap<PropertyEditorElement, Integer> elements;

    protected PropertyEditorUserCode(String userCodeLabel) {
        this.userCodeLabel = userCodeLabel;
    }

    protected void initElements(Collection<PropertyEditorElement> elements) {
        int i = 0;
        if (elements != null && elements.size() > 0) {
            this.elements = new LinkedHashMap(elements.size());
        }
        for (PropertyEditorElement element : elements) {
            this.elements.put(element, i++);
        }
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.elements != null) {
            this.elements.clear();
            this.elements = null;
        }
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.userCodeRadioButton = null;
        this.messageLabel = null;
        this.component = null;
        super.cleanUp(component);
    }

    protected void initElements(LinkedHashMap<PropertyEditorElement, Integer> elements) {
        this.elements = elements;
    }

    protected JRadioButton getUserCodeRadioButton() {
        return this.userCodeRadioButton;
    }

    public void init(DesignComponent component) {
        if (component != null) {
            this.component = new WeakReference<DesignComponent>(component);
        }
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }

    private void initCustomEditor() {
        this.messageLabel = new JLabel(" ");
        Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (nbErrorForeground == null) {
            nbErrorForeground = new Color(255, 0, 0);
        }
        this.messageLabel.setForeground(nbErrorForeground);
        this.customEditor = new CustomEditor();
        this.customEditor.init(this.elements);
        PropertyValue value = (PropertyValue)super.getValue();
        if (this.isCurrentValueAUserCodeType()) {
            this.customEditor.setUserCodeText(value.getUserCode());
            this.customEditor.updateState(null);
        } else {
            this.customEditor.setUserCodeText(null);
            this.customEditor.updateState(value);
        }
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NULL_TEXT;
        }
        return null;
    }

    public void setAsText(String text) {
        if (this.canWrite()) {
            if (text.equals(NULL_TEXT)) {
                super.setValue((Object)NULL_VALUE);
            } else if (this.customEditor != null) {
                this.customEditor.setText(text);
            }
        }
    }

    public Boolean canEditAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return false;
        }
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public void customEditorOKButtonPressed() {
        if (this.userCodeRadioButton.isSelected()) {
            this.customEditor.setNewValue();
            PropertyEditorUserCode.super.setValue(PropertyValue.createUserCode((String)this.userCode));
        }
    }

    protected boolean isCurrentValueAUserCodeType() {
        PropertyValue value = (PropertyValue)super.getValue();
        return value != null && value.getKind() == PropertyValue.Kind.USERCODE;
    }

    protected boolean isCurrentValueANull() {
        PropertyValue value = (PropertyValue)super.getValue();
        return value == null || value.getKind() == PropertyValue.Kind.NULL;
    }

    @Override
    public void displayWarning(String message) {
        this.messageLabel.setText(message);
        this.messageLabel.setIcon(ICON_WARNING);
    }

    @Override
    public void displayError(String message) {
        if (this.messageLabel == null) {
            return;
        }
        this.messageLabel.setText(message);
        this.messageLabel.setIcon(ICON_ERROR);
    }

    @Override
    public void clearErrorStatus() {
        if (this.messageLabel == null) {
            return;
        }
        this.messageLabel.setText(" ");
        this.messageLabel.setIcon(null);
    }

    private static void setupTextUndoRedo(JTextComponent editor) {
        String os = System.getProperty("os.name").toLowerCase();
        KeyStroke[] undoKeys = null;
        KeyStroke[] redoKeys = null;
        if (os.indexOf("mac") != -1) {
            undoKeys = new KeyStroke[]{KeyStroke.getKeyStroke(65483, 0), KeyStroke.getKeyStroke(90, 4)};
            redoKeys = new KeyStroke[]{KeyStroke.getKeyStroke(65481, 0), KeyStroke.getKeyStroke(89, 4)};
        } else {
            undoKeys = new KeyStroke[]{KeyStroke.getKeyStroke(65483, 0), KeyStroke.getKeyStroke(90, 130)};
            redoKeys = new KeyStroke[]{KeyStroke.getKeyStroke(65481, 0), KeyStroke.getKeyStroke(89, 130)};
        }
        Keymap keymap = editor.getKeymap();
        ActionFactory.UndoAction undoAction = new ActionFactory.UndoAction();
        for (KeyStroke k : undoKeys) {
            keymap.removeKeyStrokeBinding(k);
            keymap.addActionForKeyStroke(k, (Action)undoAction);
        }
        ActionFactory.RedoAction redoAction = new ActionFactory.RedoAction();
        for (KeyStroke k : redoKeys) {
            keymap.removeKeyStrokeBinding(k);
            keymap.addActionForKeyStroke(k, (Action)redoAction);
        }
        Object currentUM = editor.getDocument().getProperty("undo-manager");
        if (currentUM instanceof UndoManager) {
            editor.getDocument().removeUndoableEditListener((UndoManager)currentUM);
        }
        UndoManager um = new UndoManager();
        editor.getDocument().addUndoableEditListener(um);
        editor.getDocument().putProperty("undo-manager", um);
    }

    private final class CustomEditor
    extends JPanel
    implements DocumentListener,
    ActionListener,
    FocusListener {
        private Collection<PropertyEditorElement> elements;
        private Map<PropertyEditorElement, Integer> elementsMap;
        private JEditorPane userCodeEditorPane;

        private CustomEditor() {
        }

        public void init(Collection<PropertyEditorElement> elements) {
            this.elements = elements;
            this.initComponents();
        }

        public void init(Map<PropertyEditorElement, Integer> elementsMap) {
            this.elementsMap = elementsMap;
            this.elements = elementsMap.keySet();
            this.initComponents();
        }

        void cleanUp() {
            if (this.elementsMap != null) {
                for (PropertyEditorElement pee : this.elementsMap.keySet()) {
                    if (!(pee instanceof CleanUp)) continue;
                    ((CleanUp)((Object)pee)).clean(null);
                }
                this.elementsMap.clear();
                this.elementsMap = null;
            }
            if (this.elements != null) {
                this.elements = null;
            }
            if (this.userCodeEditorPane != null && this.userCodeEditorPane.getDocument() != null) {
                this.userCodeEditorPane.getDocument().removeDocumentListener(this);
                this.userCodeEditorPane = null;
            }
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints constraints = new GridBagConstraints();
            boolean isAnyElementVerticallyResizable = false;
            for (PropertyEditorElement element : this.elements) {
                if (this.elementsMap == null || this.elementsMap != null && this.elementsMap.get(element) == null) {
                    JRadioButton rb = element.getRadioButton();
                    buttonGroup.add(rb);
                    constraints.insets = new Insets(12, 12, 6, 12);
                    constraints.anchor = 18;
                    constraints.gridx = 0;
                    constraints.gridy = -1;
                    constraints.weightx = 1.0;
                    constraints.weighty = 0.0;
                    constraints.fill = 2;
                    this.add((Component)rb, constraints);
                    constraints.insets = new Insets(0, 32, 12, 12);
                    constraints.anchor = 18;
                    constraints.gridx = 0;
                    constraints.gridy = -1;
                    constraints.weightx = 1.0;
                    constraints.weighty = element.isVerticallyResizable() ? 1.0 : 0.0;
                    constraints.fill = element.isVerticallyResizable() ? 1 : 2;
                    this.add((Component)element.getCustomEditorComponent(), constraints);
                }
                if (!element.isVerticallyResizable()) continue;
                isAnyElementVerticallyResizable = true;
            }
            PropertyEditorUserCode.this.userCodeRadioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)PropertyEditorUserCode.this.userCodeRadioButton, (String)NbBundle.getMessage(PropertyEditorUserCode.class, (String)"LBL_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorUserCode.class, (String)"ACSN_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorUserCode.class, (String)"ACSD_USER_CODE", (Object)PropertyEditorUserCode.this.userCodeLabel));
            PropertyEditorUserCode.this.userCodeRadioButton.addActionListener(this);
            buttonGroup.add(PropertyEditorUserCode.this.userCodeRadioButton);
            constraints.insets = new Insets(12, 12, 6, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            this.add((Component)PropertyEditorUserCode.this.userCodeRadioButton, constraints);
            JScrollPane jsp = new JScrollPane();
            this.userCodeEditorPane = new JEditorPane();
            this.userCodeEditorPane.getAccessibleContext().setAccessibleName(PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().getAccessibleName());
            this.userCodeEditorPane.getAccessibleContext().setAccessibleDescription(PropertyEditorUserCode.this.userCodeRadioButton.getAccessibleContext().getAccessibleDescription());
            this.userCodeEditorPane.addFocusListener(this);
            this.userCodeEditorPane.setContentType("text/x-java");
            this.userCodeEditorPane.getDocument().addDocumentListener(this);
            jsp.setViewportView(this.userCodeEditorPane);
            jsp.setPreferredSize(new Dimension(400, 100));
            jsp.setMinimumSize(new Dimension(400, 100));
            constraints.insets = new Insets(0, 32, 12, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.weightx = 1.0;
            constraints.weighty = isAnyElementVerticallyResizable ? 0.0 : 1.0;
            constraints.fill = isAnyElementVerticallyResizable ? 2 : 1;
            this.add((Component)jsp, constraints);
            for (PropertyEditorElement element : this.elements) {
                if (this.elementsMap != null && this.elementsMap.get(element) != null) {
                    JRadioButton rb = element.getRadioButton();
                    buttonGroup.add(rb);
                    constraints.insets = new Insets(12, 12, 6, 12);
                    constraints.anchor = 18;
                    constraints.gridx = 0;
                    constraints.gridy = -1;
                    constraints.weightx = 1.0;
                    constraints.weighty = 0.0;
                    constraints.fill = 2;
                    this.add((Component)rb, constraints);
                    constraints.insets = new Insets(0, 32, 12, 12);
                    constraints.anchor = 18;
                    constraints.gridx = 0;
                    constraints.gridy = -1;
                    constraints.weightx = 1.0;
                    constraints.weighty = element.isVerticallyResizable() ? 1.0 : 0.0;
                    constraints.fill = element.isVerticallyResizable() ? 1 : 2;
                    this.add((Component)element.getCustomEditorComponent(), constraints);
                }
                if (!element.isVerticallyResizable()) continue;
                isAnyElementVerticallyResizable = true;
            }
            constraints.insets = new Insets(0, 12, 0, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            this.add((Component)PropertyEditorUserCode.this.messageLabel, constraints);
            this.selectDefaultRadioButton();
            PropertyEditorUserCode.this.customEditor.initRetoucheStuff();
        }

        public void initRetoucheStuff() {
            PropertyValue value;
            if (PropertyEditorUserCode.this.component == null || PropertyEditorUserCode.this.component.get() == null) {
                return;
            }
            DesignComponent _component = (DesignComponent)PropertyEditorUserCode.this.component.get();
            Document swingDoc = this.userCodeEditorPane.getDocument();
            if (swingDoc.getProperty(JavaSource.class) == null) {
                DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)_component.getDocument());
                swingDoc.putProperty("stream", context.getDataObject());
                int offset = CodeUtils.getMethodOffset(context);
                DialogBinding.bindComponentToFile((FileObject)context.getDataObject().getPrimaryFile(), (int)offset, (int)0, (JTextComponent)this.userCodeEditorPane);
                PropertyEditorUserCode.setupTextUndoRedo(this.userCodeEditorPane);
            }
            if (PropertyEditorUserCode.this.getValue() instanceof PropertyValue && (value = (PropertyValue)PropertyEditorUserCode.this.getValue()).getKind() == PropertyValue.Kind.USERCODE) {
                this.setUserCodeText(value.getUserCode());
                this.repaint();
            }
        }

        public void updateState(PropertyValue value) {
            for (PropertyEditorElement element : this.elements) {
                element.updateState(value);
            }
        }

        public void setText(String text) {
            for (PropertyEditorElement element : this.elements) {
                element.setTextForPropertyValue(text);
            }
        }

        public void setUserCodeText(String text) {
            if (text != null) {
                this.userCodeEditorPane.setText(text);
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                PropertyEditorUserCode.this.userCodeRadioButton.requestFocus();
            } else {
                this.userCodeEditorPane.setText(null);
                this.selectDefaultRadioButton();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.userCodeEditorPane.hasFocus()) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                this.setNewValue();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.userCodeEditorPane.hasFocus()) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
                this.setNewValue();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.setNewValue();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        private void setNewValue() {
            PropertyEditorUserCode.this.userCode = this.userCodeEditorPane.getText();
        }

        private void selectDefaultRadioButton() {
            boolean wasSelected = false;
            for (PropertyEditorElement element : this.elements) {
                if (!element.isInitiallySelected()) continue;
                element.getRadioButton().setSelected(true);
                element.getRadioButton().requestFocus();
                wasSelected = true;
                break;
            }
            PropertyEditorUserCode.this.userCodeRadioButton.setSelected(!wasSelected);
            if (!wasSelected) {
                this.userCodeEditorPane.requestFocus();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == this.userCodeEditorPane) {
                PropertyEditorUserCode.this.userCodeRadioButton.setSelected(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

