/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.util.NbBundle;

public class PropertyEditorVersion
extends DesignPropertyEditor {
    private CustomEditor customEditor = new CustomEditor();

    private PropertyEditorVersion() {
    }

    public static final PropertyEditorVersion createInstance() {
        return new PropertyEditorVersion();
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
    }

    public Component getCustomEditor() {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value != null && value.getKind() != PropertyValue.Kind.NULL) {
            this.customEditor.setText((String)value.getPrimitiveValue());
        }
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value == null || value.getKind() == PropertyValue.Kind.NULL) {
            return PropertyEditorUserCode.NULL_TEXT;
        }
        return (String)value.getPrimitiveValue();
    }

    public void setAsText(String text) {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value != null && value.getPrimitiveValue().equals(text)) {
            return;
        }
        if (!PropertyEditorUserCode.NULL_TEXT.equals(text)) {
            this.saveValue(text);
        }
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(text));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        this.saveValue(this.customEditor.getText());
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    private final class CustomEditor
    extends JPanel {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            this.textField = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel label = new JLabel(NbBundle.getMessage(PropertyEditorVersion.class, (String)"LBL_VERSION_STR"));
            constraints.insets = new Insets(12, 12, 12, 6);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            this.add((Component)label, constraints);
            this.textField = new JTextField();
            constraints.insets = new Insets(12, 6, 12, 12);
            constraints.anchor = 18;
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            this.add((Component)this.textField, constraints);
            this.setPreferredSize(new Dimension(300, 40));
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }
    }
}

