/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorTimeout
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String FOREVER_TEXT = NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUTPE_FOREVER_TXT");
    private static final String FOREVER_NUM_TEXT = String.valueOf(AlertCD.FOREVER_VALUE.getPrimitiveValue());
    private CustomEditor customEditor;
    private JRadioButton radioButton;

    private PropertyEditorTimeout() {
        super(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUT_UCLABEL"));
    }

    public static final PropertyEditorTimeout createInstance() {
        return new PropertyEditorTimeout();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUT_STR"));
        this.customEditor = new CustomEditor();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        Object valueValue = ((PropertyValue)super.getValue()).getPrimitiveValue();
        Object foreverValueValue = AlertCD.FOREVER_VALUE.getPrimitiveValue();
        if (foreverValueValue.equals(valueValue)) {
            return FOREVER_TEXT;
        }
        return String.valueOf(valueValue);
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.unsetForever(true);
        } else if (AlertCD.FOREVER_VALUE.getPrimitiveValue().equals(value.getPrimitiveValue())) {
            this.customEditor.setForever(true);
        } else {
            this.customEditor.unsetForever(true);
            this.customEditor.setText(String.valueOf(value.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            if (FOREVER_TEXT.equals(text) || FOREVER_NUM_TEXT.equals(text)) {
                super.setValue((Object)AlertCD.FOREVER_VALUE);
                return;
            }
            int intValue = 0;
            try {
                text = text.replaceAll("[^0-9\\-]+", "");
                intValue = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setValue((Object)MidpTypes.createIntegerValue(intValue));
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    @Override
    public Boolean canEditAsText() {
        if (!this.isCurrentValueAUserCodeType()) {
            PropertyValue value = (PropertyValue)super.getValue();
            if (value == null) {
                return false;
            }
            Object foreverValueValue = AlertCD.FOREVER_VALUE.getPrimitiveValue();
            return !foreverValueValue.equals(value.getPrimitiveValue());
        }
        return false;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;
        private JCheckBox foreverCheckBox;

        public CustomEditor() {
            PropertyEditorTimeout.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.foreverCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.foreverCheckBox = new JCheckBox();
            this.foreverCheckBox.addActionListener(this);
            this.foreverCheckBox.addFocusListener(this);
            Mnemonics.setLocalizedText((AbstractButton)this.foreverCheckBox, (String)NbBundle.getMessage(PropertyEditorTimeout.class, (String)"LBL_TIMEOUTPE_FOREVER"));
            this.add((Component)this.foreverCheckBox, "North");
            this.foreverCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUTPE_FOREVER"));
            this.foreverCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUTPE_FOREVER"));
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "South");
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSN_TIMEOUTPE_VALUE"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorTimeout.class, (String)"ACSD_TIMEOUTPE_VALUE"));
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setForever(boolean changeCheckBox) {
            this.setText(FOREVER_NUM_TEXT);
            this.textField.setEditable(false);
            if (changeCheckBox) {
                this.foreverCheckBox.setSelected(true);
            }
        }

        public void unsetForever(boolean changeCheckBox) {
            this.setText(null);
            this.textField.setEditable(true);
            if (changeCheckBox) {
                this.foreverCheckBox.setSelected(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.foreverCheckBox.isSelected()) {
                this.setForever(false);
            } else {
                this.unsetForever(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorTimeout.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorTimeout.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[\\d\\-]+", this.textField.getText())) {
                PropertyEditorTimeout.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            } else {
                PropertyEditorTimeout.this.clearErrorStatus();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == PropertyEditorTimeout.this.radioButton || e.getSource() == this.textField || e.getSource() == this.foreverCheckBox) {
                this.checkNumberStatus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorTimeout.this.clearErrorStatus();
        }
    }
}

