/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.displayables;

import java.util.Arrays;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeMultiGuardedLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.commands.ListSelectCommandCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCode;
import org.netbeans.modules.vmd.midp.components.displayables.ListCD;

public class ListCode {
    private static final String LIST_ACTION_METHOD_SUFFIX = "Action";
    public static final String PARAM_STRING = "elementString";
    public static final String PARAM_IMAGE = "elementImage";
    static final String PARAM_FONT = "elementFont";
    static final String PARAM_SELECTED_ARRAY = "elementSelectedArray";
    static final String PARAM_STRING_ARRAY = "elementStringArray";
    static final String PARAM_IMAGE_ARRAY = "elementImageArray";
    static final String PARAM_SELECT_COMMAND = "selectCommand";
    static final String PARAM_LIST_TYPE = "listType";
    static final String PARAM_FIT_POLICY = "fitPolicy";

    public static Parameter createStringParameter() {
        return new StringParameter();
    }

    public static Parameter createImageParameter() {
        return new ImageParameter();
    }

    public static Parameter createFontParameter() {
        return new FontParameter();
    }

    public static Parameter createSelectArrayParameter() {
        return new SelectedArrayParameter();
    }

    public static Parameter createStringArrayParameter() {
        return new StringArrayParameter();
    }

    public static Parameter createImageArrayParameter() {
        return new ImageArrayParameter();
    }

    public static String getListActionMethodAccessCode(DesignComponent list) {
        if (list == null || !list.getDocument().getDescriptorRegistry().isInHierarchy(ListCD.TYPEID, list.getType())) {
            return null;
        }
        return MidpTypes.getString(list.readProperty("instanceName")) + LIST_ACTION_METHOD_SUFFIX;
    }

    public static Presenter createListActionCodeNamePresenter() {
        return new ListActionCodeNamePresenter();
    }

    public static Presenter createListActionCodeClassLevelPresenter() {
        return new ListActionCodeClassLevelPresenter();
    }

    public static Parameter createSelectCommandParameter() {
        return new SelectCommandParameter();
    }

    public static Parameter createListCommandParameter() {
        return new ListCommandParameter();
    }

    public static Parameter createListTypeParameter() {
        return new ListTypeParameter();
    }

    public static Parameter createFitPolicyParameter() {
        return new FitPolicyParameter();
    }

    private static class FitPolicyParameter
    extends MidpParameter {
        protected FitPolicyParameter() {
            super(ListCode.PARAM_FIT_POLICY);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ListCode.PARAM_FIT_POLICY);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value) {
                    case 0: {
                        section.getWriter().write("Choice.TEXT_WRAP_DEFAULT");
                        break;
                    }
                    case 1: {
                        section.getWriter().write("Choice.TEXT_WRAP_ON");
                        break;
                    }
                    case 2: {
                        section.getWriter().write("Choice.TEXT_WRAP_OFF");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static class ListTypeParameter
    extends MidpParameter {
        protected ListTypeParameter() {
            super(ListCode.PARAM_LIST_TYPE);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ListCode.PARAM_LIST_TYPE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value) {
                    case 3: {
                        section.getWriter().write("Choice.IMPLICIT");
                        break;
                    }
                    case 1: {
                        section.getWriter().write("Choice.EXCLUSIVE");
                        break;
                    }
                    case 2: {
                        section.getWriter().write("Choice.MULTIPLE");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static final class ListActionCodeClassLevelPresenter
    extends CodeClassLevelPresenter.Adapter {
        private ListActionCodeClassLevelPresenter() {
        }

        protected void generateClassBodyCode(StyledDocument document) {
            DesignComponent list = this.getComponent();
            List array = list.readProperty("elements").getArray();
            MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(list.getComponentID() + "-action"));
            String listName = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)list);
            String methodName = listName + ListCode.LIST_ACTION_METHOD_SUFFIX;
            section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: " + methodName + " \">\n");
            section.getWriter().write("/**\n * Performs an action assigned to the selected list element in the " + listName + " component.\n */\n");
            section.getWriter().write("public void " + methodName + " () {\n").commit();
            section.switchToEditable(list.getComponentID() + "-preAction");
            section.getWriter().write(" // enter pre-action user code here\n").commit();
            section.switchToGuarded();
            String listInstanceName = CodeReferencePresenter.generateAccessCode((DesignComponent)list);
            boolean indexBased = MidpTypes.getBoolean(list.readProperty("indexBasedSwitch"));
            if (!indexBased) {
                section.getWriter().write("String __selectedString = " + listInstanceName + ".getString (" + listInstanceName + ".getSelectedIndex ());\n");
            }
            if (array.size() > 0) {
                if (indexBased) {
                    section.getWriter().write("switch (" + listInstanceName + ".getSelectedIndex ()) {\n");
                } else {
                    section.getWriter().write("if (__selectedString != null) {\n");
                }
                for (int i = 0; i < array.size(); ++i) {
                    PropertyValue value = (PropertyValue)array.get(i);
                    DesignComponent source = value.getComponent();
                    if (indexBased) {
                        section.getWriter().write("case " + i + ":\n");
                    } else {
                        if (i > 0) {
                            section.getWriter().write("} else ");
                        }
                        section.getWriter().write("if (__selectedString.equals (");
                        MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), source.readProperty("string"));
                        section.getWriter().write(")) {\n");
                    }
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)section, (DesignComponent)source);
                    if (!indexBased) continue;
                    section.getWriter().write("break;\n");
                }
                if (!indexBased) {
                    section.getWriter().write("}\n");
                }
                section.getWriter().write("}\n");
            }
            section.getWriter().commit();
            section.switchToEditable(list.getComponentID() + "-postAction");
            section.getWriter().write(" // enter post-action user code here\n").commit();
            section.switchToGuarded();
            section.getWriter().write("}\n");
            section.getWriter().write("//</editor-fold>\n").commit();
            section.close();
        }
    }

    private static final class ListActionCodeNamePresenter
    extends CodeNamePresenter {
        private ListActionCodeNamePresenter() {
        }

        public List<String> getReservedNames() {
            return this.getReservedNamesFor(MidpTypes.getString(this.getComponent().readProperty("instanceName")));
        }

        public List<String> getReservedNamesFor(String suggestedMainName) {
            return Arrays.asList(suggestedMainName + ListCode.LIST_ACTION_METHOD_SUFFIX);
        }
    }

    private static final class ListCommandParameter
    extends DisplayableCode.CommandParameter {
        private ListCommandParameter() {
        }

        @Override
        public int getParameterPriority() {
            return super.getParameterPriority() + 1;
        }

        @Override
        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            DescriptorRegistry descriptorRegistry = component.getDocument().getDescriptorRegistry();
            List array = component.readProperty("commands").getArray();
            DesignComponent commandEventSource = ((PropertyValue)array.get(index)).getComponent();
            DesignComponent command = commandEventSource.readProperty("command").getComponent();
            if (command != null && descriptorRegistry.isInHierarchy(ListSelectCommandCD.TYPEID, command.getType())) {
                return false;
            }
            return super.isRequiredToBeSet(command, index);
        }
    }

    private static class SelectCommandParameter
    implements Parameter {
        private SelectCommandParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_SELECT_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), this.getSelectCommand(component));
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            DesignComponent selectCommand = this.getSelectCommand(component).getComponent();
            DescriptorRegistry descriptorRegistry = component.getDocument().getDescriptorRegistry();
            return selectCommand == null || !descriptorRegistry.isInHierarchy(ListSelectCommandCD.TYPEID, selectCommand.getType());
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private PropertyValue getSelectCommand(DesignComponent component) {
            DesignComponent source = component.readProperty(ListCode.PARAM_SELECT_COMMAND).getComponent();
            return source != null ? source.readProperty("command") : PropertyValue.createNull();
        }
    }

    private static class ImageArrayParameter
    implements Parameter {
        private ImageArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_IMAGE_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new Image[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue listElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent listElement = listElementValue.getComponent();
                PropertyValue image = listElement.readProperty("image");
                MidpCodeSupport.generateCodeForPropertyValue(writer, image);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class StringArrayParameter
    implements Parameter {
        private StringArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_STRING_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new String[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue listElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent listElement = listElementValue.getComponent();
                PropertyValue string = listElement.readProperty("string");
                MidpCodeSupport.generateCodeForPropertyValue(writer, string);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class SelectedArrayParameter
    implements Parameter {
        private SelectedArrayParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_SELECTED_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new boolean[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue listElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent listElement = listElementValue.getComponent();
                PropertyValue string = listElement.readProperty("selected");
                MidpCodeSupport.generateCodeForPropertyValue(writer, string);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class FontParameter
    implements Parameter {
        private FontParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_FONT;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent listElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = listElement.readProperty("font");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent listElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = listElement.readProperty("font");
            return string.getKind() != PropertyValue.Kind.NULL;
        }
    }

    private static class ImageParameter
    implements Parameter {
        private ImageParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_IMAGE;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent listElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = listElement.readProperty("image");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }

    private static class StringParameter
    implements Parameter {
        private StringParameter() {
        }

        public String getParameterName() {
            return ListCode.PARAM_STRING;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent listElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = listElement.readProperty("string");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }
}

