/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.displayables;

import java.awt.datatransfer.Transferable;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpAcceptTrensferableKindPresenter;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.general.FileAcceptPresenter;
import org.openide.filesystems.FileObject;

public final class FormAcceptPresenterSupport {
    public static Presenter createFileAcceptPresenter(String ... fileExtensions) {
        return new FormFileAcceptPresenter(fileExtensions);
    }

    public static Presenter createImageAcceptPresenter() {
        return new FormTypeAccepter().addType(ImageCD.TYPEID, "image");
    }

    private static class FormTypeAccepter
    extends MidpAcceptTrensferableKindPresenter {
        private FormTypeAccepter() {
        }

        @Override
        public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
            DesignDocument document = this.getComponent().getDocument();
            DesignComponent image = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
            ComponentProducer ip = DocumentSupport.getComponentProducer((DesignDocument)this.getComponent().getDocument(), (String)ImageItemCD.TYPEID.toString());
            if (ip == null) {
                return super.accept(transferable, suggestion);
            }
            DesignComponent imageItem = (DesignComponent)ip.createComponent(document).getComponents().iterator().next();
            imageItem.writeProperty("image", PropertyValue.createComponentReference((DesignComponent)image));
            MidpArraySupport.append(this.getComponent(), "items", imageItem);
            this.getComponent().addComponent(imageItem);
            return new ComponentProducer.Result(new DesignComponent[]{imageItem});
        }
    }

    private static class FormFileAcceptPresenter
    extends FileAcceptPresenter {
        private FormFileAcceptPresenter(String ... fileExtensions) {
            super("items", ImageItemCD.TYPEID, fileExtensions);
        }

        @Override
        public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
            DesignDocument document = this.getComponent().getDocument();
            ComponentProducer.Result result = super.accept(transferable, suggestion);
            DesignComponent component = (DesignComponent)result.getComponents().iterator().next();
            ComponentProducer ip = DocumentSupport.getComponentProducer((DesignDocument)this.getComponent().getDocument(), (String)ImageCD.TYPEID.toString());
            if (ip == null) {
                return super.accept(transferable, suggestion);
            }
            DesignComponent image = ip.createComponent(document).getMainComponent();
            component.writeProperty("image", PropertyValue.createComponentReference((DesignComponent)image));
            FileObject fileObject = this.getNodeFileObject(transferable);
            String path = this.getFileClasspath(fileObject);
            image.writeProperty("resourcePath", MidpTypes.createStringValue(path));
            MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID).addComponent(image);
            this.getComponent().addComponent(component);
            return new ComponentProducer.Result(new DesignComponent[]{component});
        }
    }
}

