/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public class ProcessStatusProvider64
implements ProcessStatusProvider {
    private final NativeProcessBuilder npb;
    private final Pattern lwpPattern;
    private final PStatus.PIDInfo pidInfo;

    public ProcessStatusProvider64(ExecutionEnvironment execEnv, int pid) {
        this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
        this.npb.setExecutable("/bin/pflags").setArguments(new String[]{"" + pid});
        this.lwpPattern = Pattern.compile("^[\t ]+\\/([0-9]+):.*");
        this.pidInfo = new PStatus.PIDInfo(pid){};
    }

    @Override
    public PStatus getProcessStatus() {
        PStatus status = null;
        try {
            NativeProcess p = this.npb.call();
            List lines = ProcessUtils.readProcessOutput((Process)p);
            int count = 0;
            for (String line : lines) {
                Matcher m = this.lwpPattern.matcher(line);
                if (!m.matches()) continue;
                ++count;
            }
            int rc = -1;
            try {
                rc = p.waitFor();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (rc == 0) {
                final int pr_nlwp = count;
                status = new PStatus(){

                    @Override
                    public PStatus.ThreadsInfo getThreadInfo() {
                        return new PStatus.ThreadsInfo(pr_nlwp, 0){};
                    }

                    @Override
                    public PStatus.PIDInfo getPIDInfo() {
                        return ProcessStatusProvider64.this.pidInfo;
                    }
                };
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }
}

