/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;

public final class SQLConnection {
    private static final Logger logger = DLightLogger.getLogger(SQLConnection.class);
    private Connection connection = null;
    private String logPrefix = "";
    private PreparedStatement emptyResultStatement;

    public synchronized Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                this.log(ex);
            }
            finally {
                this.connection = null;
                this.emptyResultStatement = null;
            }
        }
    }

    public synchronized void connect(Connection connection) {
        if (this.connection != null) {
            throw new IllegalStateException("Already connected!");
        }
        this.connection = connection;
        try {
            this.emptyResultStatement = connection.prepareStatement("select 0 where 1 = 2");
        }
        catch (SQLException ex) {
            this.log("Unable to prepare emptyResultStatement");
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                this.logPrefix = connection.getMetaData().getURL() + ": ";
            }
            catch (SQLException ex) {
                this.log(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, AtomicBoolean resultType) {
        try {
            Statement stmt = this.createStatement();
            try {
                boolean result = stmt.execute(sql);
                if (resultType != null) {
                    resultType.set(result);
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            this.log(ex);
            return false;
        }
        return true;
    }

    public boolean execute(String sql) {
        return this.execute(sql, null);
    }

    private synchronized Statement createStatement() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Not connected");
        }
        return this.connection.createStatement();
    }

    public ResultSet executeQuery(String sqlQuery) {
        ResultSet rs;
        try {
            rs = this.createStatement().executeQuery(sqlQuery);
        }
        catch (SQLException ex) {
            this.log(ex);
            if (this.emptyResultStatement != null) {
                try {
                    return this.emptyResultStatement.executeQuery();
                }
                catch (SQLException ex1) {
                    logger.log(Level.SEVERE, "Unable to get empty ResultSet", ex1);
                }
            }
            rs = null;
        }
        return rs;
    }

    private void log(SQLException ex) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, this.logPrefix, ex);
        }
    }

    private void log(String message) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, this.logPrefix.concat(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql) throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql) {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this.log(ex);
            return null;
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.log(ex);
            return null;
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.log(ex);
            return null;
        }
    }
}

