/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;

public final class SQLStatementsCache {
    private static final HashMap<SQLDataStorage, SQLStatementsCache> storageToCache = new HashMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final SQLDataStorage sqlStorage;
    private AtomicReference<ConcurrentHashMap<String, PreparedStatement>> cache = new AtomicReference();

    private SQLStatementsCache(SQLDataStorage sqlStorage) {
        this.sqlStorage = sqlStorage;
        this.cache.set(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLStatementsCache getFor(SQLDataStorage sqlStorage) {
        HashMap<SQLDataStorage, SQLStatementsCache> hashMap = storageToCache;
        synchronized (hashMap) {
            if (!storageToCache.containsKey(sqlStorage)) {
                storageToCache.put(sqlStorage, new SQLStatementsCache(sqlStorage));
            }
        }
        return storageToCache.get(sqlStorage);
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement oldStmt;
        if (this.closed.get()) {
            throw new SQLException("Already closed");
        }
        ConcurrentHashMap<String, PreparedStatement> data = this.cache.get();
        PreparedStatement stmt = data.get(sql);
        if (stmt == null && (oldStmt = data.putIfAbsent(sql, stmt = this.sqlStorage.prepareStatement(sql))) != null) {
            stmt = oldStmt;
        }
        return stmt;
    }

    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            ConcurrentHashMap data = this.cache.getAndSet(null);
            for (PreparedStatement stmt : data.values()) {
                stmt.close();
            }
        }
    }
}

