/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class DLightConfigurationManager {
    private static final String ROOT = "DLight/Configurations";
    private static final DLightConfigurationManager instance = new DLightConfigurationManager();
    private final List<DLightConfiguration> configurations = new ArrayList<DLightConfiguration>();
    private final FSListener fslistener = new FSListener();
    private final FileObject cfgRoot;

    private DLightConfigurationManager() {
        FileObject root = FileUtil.getConfigRoot().getFileObject(ROOT);
        if (root == null) {
            System.err.println("Configurations folder is NULL which should not be");
            try {
                root = FileUtil.getConfigRoot().createFolder("FAKE");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.cfgRoot = root;
        } else {
            this.cfgRoot = root;
            this.listenerOn();
        }
    }

    public static DLightConfigurationManager getInstance() {
        return instance;
    }

    private synchronized void refreshConfigurations() {
        this.configurations.clear();
        for (FileObject cfgFile : this.cfgRoot.getChildren()) {
            this.configurations.add(DLightConfiguration.create(cfgFile));
        }
    }

    boolean canDelete(String configurationName) {
        DLightConfiguration configuration = this.getConfigurationByName(configurationName);
        return configuration != null && !configuration.isSystem();
    }

    synchronized boolean removeConfiguration(String configurationName) {
        DLightConfiguration cfg = this.getConfigurationByName(configurationName);
        if (cfg == null) {
            return false;
        }
        try {
            cfg.getRootFolder().delete();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private String commaSeparatedList(List<String> list) {
        StringBuilder res = new StringBuilder();
        for (String s : list) {
            if (res.length() > 0) {
                res.append(',');
            }
            res.append(s);
        }
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DLightConfiguration registerConfigurationAsACopy(DLightConfiguration configuration, String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
        FileObject copy = null;
        try {
            this.listenerOff();
            copy = configuration.getRootFolder().copy(this.cfgRoot, configurationName, null);
            copy.setAttribute("displayedName", (Object)displayedName);
            copy.setAttribute("category", (Object)category);
            copy.setAttribute("platforms", (Object)this.commaSeparatedList(platforms));
            copy.setAttribute("collector.providers", (Object)collector);
            copy.setAttribute("indicator.providers", (Object)this.commaSeparatedList(indicators));
            copy.setAttribute("system", (Object)false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            DLightConfiguration dLightConfiguration = null;
            return dLightConfiguration;
        }
        finally {
            this.listenerOn();
        }
        return this.getConfigurationByName(configurationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DLightConfiguration registerConfiguration(String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
        try {
            this.listenerOff();
            FileObject cfg = this.cfgRoot.createFolder(configurationName);
            cfg.setAttribute("displayedName", (Object)displayedName);
            cfg.setAttribute("category", (Object)category);
            cfg.setAttribute("platforms", (Object)this.commaSeparatedList(platforms));
            cfg.setAttribute("collector.providers", (Object)collector);
            cfg.setAttribute("indicator.providers", (Object)this.commaSeparatedList(indicators));
            cfg.createFolder("KnownToolsConfigurationProviders");
        }
        catch (IOException ex) {
            DLightConfiguration dLightConfiguration = null;
            return dLightConfiguration;
        }
        finally {
            this.listenerOn();
        }
        return this.getConfigurationByName(configurationName);
    }

    public synchronized Collection<DLightConfiguration> getConfigurationsByCategoryName(String categoryName) {
        if (categoryName == null) {
            return Collections.emptyList();
        }
        ArrayList<DLightConfiguration> result = new ArrayList<DLightConfiguration>();
        for (DLightConfiguration conf : this.configurations) {
            if (!categoryName.equals(conf.getCategoryName())) continue;
            result.add(conf);
        }
        return result;
    }

    public synchronized DLightConfiguration getConfigurationByName(String configurationName) {
        for (DLightConfiguration conf : this.configurations) {
            if (!conf.getConfigurationName().equals(configurationName)) continue;
            return conf;
        }
        return null;
    }

    synchronized List<DLightConfiguration> getDLightConfigurations() {
        return Collections.unmodifiableList(this.configurations);
    }

    public final DLightConfiguration getDefaultConfiguration() {
        return DLightConfiguration.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized boolean registerTool(String configurationName, String toolID, boolean isOnByDefault) {
        boolean result;
        DLightConfiguration configurationToRegister = this.getConfigurationByName(configurationName);
        DLightConfiguration allToolsConfiguration = this.getDefaultConfiguration();
        ToolsConfiguration toolsConfiguration = configurationToRegister.getToolsConfiguration();
        try {
            this.listenerOff();
            FileObject toolFileObject = allToolsConfiguration.getToolsConfiguration().getFileObject(toolID);
            result = toolsConfiguration.register(toolFileObject, isOnByDefault);
        }
        finally {
            this.listenerOn();
        }
        return result;
    }

    final boolean registerTool(String configurationName, DLightTool tool) {
        return this.registerTool(configurationName, tool.getID(), tool.isEnabled());
    }

    final boolean deleteTool(String configurationName, DLightTool tool) {
        return this.getConfigurationByName(configurationName).getToolsConfiguration().remove(tool.getID());
    }

    private void listenerOn() {
        this.cfgRoot.addRecursiveListener((FileChangeListener)this.fslistener);
        this.refreshConfigurations();
    }

    private void listenerOff() {
        this.cfgRoot.removeRecursiveListener((FileChangeListener)this.fslistener);
    }

    static {
        DLightConfigurationManagerAccessor.setDefault(new DLightConfigurationManagerAccessorImpl());
    }

    private class FSListener
    implements FileChangeListener {
        private FSListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }

        public void fileDataCreated(FileEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }

        public void fileChanged(FileEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }

        public void fileDeleted(FileEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }

        public void fileRenamed(FileRenameEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            DLightConfigurationManager.this.refreshConfigurations();
        }
    }

    private static class DLightConfigurationManagerAccessorImpl
    extends DLightConfigurationManagerAccessor {
        private DLightConfigurationManagerAccessorImpl() {
        }

        @Override
        public DLightConfiguration getDefaultConfiguration() {
            return instance.getDefaultConfiguration();
        }

        @Override
        public List<DLightConfiguration> getDLightConfigurations() {
            return instance.getDLightConfigurations();
        }

        @Override
        public boolean registerTool(String configurationName, DLightTool tool) {
            return instance.registerTool(configurationName, tool);
        }

        @Override
        public boolean deleteTool(String configurationName, DLightTool tool) {
            return instance.deleteTool(configurationName, tool);
        }

        @Override
        public DLightConfiguration registerConfiguration(String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
            return instance.registerConfiguration(configurationName, displayedName, category, platforms, collector, indicators);
        }

        @Override
        public DLightConfiguration registerConfigurationAsACopy(DLightConfiguration configuration, String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
            return instance.registerConfigurationAsACopy(configuration, configurationName, displayedName, category, platforms, collector, indicators);
        }

        @Override
        public boolean removeConfiguration(String configurationName) {
            return instance.removeConfiguration(configurationName);
        }

        @Override
        public boolean canRemoveConfiguration(String configurationName) {
            return instance.canDelete(configurationName);
        }

        @Override
        public boolean registerTool(String configurationName, String toolID, boolean isOneByDefault) {
            return instance.registerTool(configurationName, toolID, isOneByDefault);
        }
    }
}

