/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.CallStackTreeModel;
import org.netbeans.modules.dlight.core.stack.ui.MergedStackRootNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MergedCallStackPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final MergedStackRootNode rootNode;
    private final BeanTreeView treeView;
    private Lookup lookup;
    private SourceFileInfoDataProvider sourceFileInfoDataProvider;

    private MergedCallStackPanel(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        this.setLayout(new BoxLayout(this, 1));
        this.sourceFileInfoDataProvider = sourceFileInfoDataProvider;
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)new ActionMap());
        this.treeView = new MyOwnBeanTreeView();
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView);
        AbstractAction expandAll = new AbstractAction(NbBundle.getMessage(MergedCallStackPanel.class, (String)"ExpandAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergedCallStackPanel.this.treeView.expandAll();
            }
        };
        CallStackTreeModel treeModel = new CallStackTreeModel(this.sourceFileInfoDataProvider);
        this.rootNode = new MergedStackRootNode(expandAll, treeModel);
        this.manager.setRootContext((Node)this.rootNode);
        final JPopupMenu popup = new JPopupMenu();
        popup.add(expandAll);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    popup.show(MergedCallStackPanel.this, e.getX(), e.getY());
                }
            }
        });
        ActionMap map = new ActionMap();
        map.put("org.openide.actions.PopupAction", expandAll);
        this.setActionMap(map);
        this.treeView.setPopupAllowed(true);
        this.treeView.setActionMap(map);
    }

    public static MergedCallStackPanel createInstance() {
        return new MergedCallStackPanel(null);
    }

    public void setSourceProvider(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        this.sourceFileInfoDataProvider = sourceFileInfoDataProvider;
        this.rootNode.setSourceFileInfoProvider(sourceFileInfoDataProvider);
    }

    public static MergedCallStackPanel createInstance(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        return new MergedCallStackPanel(sourceFileInfoDataProvider);
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.treeView != null) {
            return this.treeView.requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    public void clean() {
        this.rootNode.removeAll();
        this.treeView.setRootVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.treeView.expandAll();
    }

    @Override
    public void requestFocus() {
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public void expandAll() {
        if (this.manager.getRootContext() == null) {
            return;
        }
        this.treeView.expandAll();
    }

    public void scrollToRoot() {
        this.treeView.getViewport().setViewPosition(new Point(0, 0));
    }

    public void expandNode(Node node) {
        this.treeView.expandNode(node);
    }

    public void setRootVisible(String rootName) {
        this.treeView.setRootVisible(true);
        this.rootNode.setDisplayName(rootName);
    }

    public final void add(List<FunctionCall> stack) {
        this.rootNode.addStack(stack);
    }

    public void update() {
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private static final class MyOwnBeanTreeView
    extends BeanTreeView {
        MyOwnBeanTreeView() {
        }

        public void expandAll() {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyOwnBeanTreeView.super.expandAll();
                    }
                });
            } else {
                super.expandAll();
            }
        }
    }
}

