/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.HashMap;

final class MetricsCache {
    private final HashMap<HashKey, Metrics> nodeCache = new HashMap();
    private final HashMap<HashKey, Metrics> funcCache = new HashMap();

    MetricsCache() {
    }

    public void updateFunctionMetrics(long funcID, long contextID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        this.updateMetrics(this.funcCache, funcID, contextID, bucket, duration, addIncl, addExcl);
    }

    public void updateNodeMetrics(long nodeID, long contextID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        this.updateMetrics(this.nodeCache, nodeID, contextID, bucket, duration, addIncl, addExcl);
    }

    public Metrics getAndResetFunctionMetrics(long funcID, long contextID, long bucket) {
        return this.getAndResetMetrics(this.funcCache, funcID, contextID, bucket);
    }

    public Metrics getAndResetNodeMetrics(long nodeID, long contextID, long bucket) {
        return this.getAndResetMetrics(this.nodeCache, nodeID, contextID, bucket);
    }

    private synchronized void updateMetrics(HashMap<HashKey, Metrics> cache, long objectID, long contextID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        HashKey key = new HashKey(objectID, contextID, bucket);
        Metrics metrics = cache.get(key);
        if (metrics == null) {
            metrics = new Metrics();
            cache.put(key, metrics);
        }
        if (addIncl) {
            metrics.incl += duration;
        }
        if (addExcl) {
            metrics.excl += duration;
        }
    }

    private synchronized Metrics getAndResetMetrics(HashMap<HashKey, Metrics> cache, long objectID, long contextID, long bucket) {
        return cache.remove(new HashKey(objectID, contextID, bucket));
    }

    public static final class Metrics {
        long incl;
        long excl;
    }

    private static final class HashKey {
        private final long objID;
        private final long contextID;
        private final long bucket;

        public HashKey(long objID, long contextID, long bucket) {
            this.objID = objID;
            this.contextID = contextID;
            this.bucket = bucket;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HashKey)) {
                return false;
            }
            HashKey that = (HashKey)obj;
            return this.objID == that.objID && this.contextID == that.contextID && this.bucket == that.bucket;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (int)(this.objID ^ this.objID >>> 32);
            hash = 97 * hash + (int)(this.contextID ^ this.contextID >>> 32);
            hash = 97 * hash + (int)(this.bucket ^ this.bucket >>> 32);
            return hash;
        }
    }
}

