/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api.support;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.NumberFormat;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;

public final class FunctionMetricFormatter {
    private static NumberFormat format = null;
    private static NumberFormat longFormat = null;

    private static String formatValue(Object value) {
        if (format == null) {
            format = NumberFormat.getNumberInstance();
            format.setGroupingUsed(false);
            format.setMinimumIntegerDigits(1);
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(1);
        }
        return format.format(value);
    }

    private static String longFormatValue(Object value) {
        if (longFormat == null) {
            longFormat = NumberFormat.getNumberInstance();
            longFormat.setGroupingUsed(false);
            longFormat.setMinimumIntegerDigits(1);
            longFormat.setMinimumFractionDigits(1);
            longFormat.setMaximumFractionDigits(5);
        }
        return longFormat.format(value);
    }

    public static String getFormattedValue(FunctionCallWithMetric functionCall, String metricID) {
        PropertyEditor editor;
        Object value = functionCall.getMetricValue(metricID);
        if (value instanceof Double || value instanceof Float) {
            return FunctionMetricFormatter.formatValue(value);
        }
        if (value instanceof Time) {
            return FunctionMetricFormatter.formatValue((double)((Time)value).getNanos() / 1.0E9);
        }
        PropertyEditor propertyEditor = editor = value == null ? null : PropertyEditorManager.findEditor(value.getClass());
        if (editor != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        return value + "";
    }

    public static String getLongFormattedValue(FunctionCallWithMetric functionCall, String metricID) {
        PropertyEditor editor;
        Object value = functionCall.getMetricValue(metricID);
        if (value instanceof Double || value instanceof Float) {
            return FunctionMetricFormatter.longFormatValue(value);
        }
        if (value instanceof Time) {
            return FunctionMetricFormatter.longFormatValue((double)((Time)value).getNanos() / 1.0E9);
        }
        PropertyEditor propertyEditor = editor = value == null ? null : PropertyEditorManager.findEditor(value.getClass());
        if (editor != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        return value + "";
    }
}

