/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsConfigurationHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.ProjectTemplateZipHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.BasicModuleConfWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DescriptorsWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.JavaMELibsWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CustomComponentWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String WIZARD_PANEL_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String LBL_WIZARD_STEPS_COUNT = "LBL_WizardStepsCount";
    public static final String CONTENT_DATA = "WizardPanel_contentData";
    public static final String SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    public static final String BUNDLE_PROPERTIES = "Bundle.properties";
    public static final String LAYER_XML = "layer.xml";
    public static final String STEP_BASIC_PARAMS = "LBL_BasicProjectParamsStep";
    public static final String LBL_LIBRARIES = "LBL_LibrariesDescStep";
    public static final String LBL_COMPONENT_DESC = "LBL_ComponentsDescStep";
    public static final String FINAL_STEP = "LBL_FinalStep";
    public static final String PROJECT_DIR = "projDir";
    public static final String PROJECT_NAME = "projName";
    public static final String SET_AS_MAIN = "setAsMain";
    public static final String LAYER_PATH = "layer";
    public static final String BUNDLE_PATH = "bundle";
    public static final String CODE_BASE_NAME = "codeBaseName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String LIBRARIES = "libraries";
    public static final String LIB_DISPLAY_NAMES = "libDisplayNames";
    public static final String LIB_NAMES = "libNames";
    public static final String CUSTOM_COMPONENTS = "customComponents";
    private static final String TEMPLATE_PROJECT_STANDALONE = "CustomComponentProject_standalone.zip";
    private static final String TEMPLATE_PROJECT_SUITECOMPONENT = "CustomComponentProject_suitecomponent.zip";
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor myWizard;

    private CustomComponentWizardIterator() {
    }

    public static CustomComponentWizardIterator createIterator() {
        return new CustomComponentWizardIterator();
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new CustomComponentWizardPanel(), new BasicModuleConfWizardPanel(), new JavaMELibsWizardPanel(), new DescriptorsWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(CustomComponentWizardIterator.class, (String)STEP_BASIC_PARAMS), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)FINAL_STEP), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_LIBRARIES), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_COMPONENT_DESC)};
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.myWizard.getProperty(PROJECT_DIR)));
        dirF.mkdirs();
        FileObject template = this.getProjectTemplate(this.myWizard);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        ProjectTemplateZipHelper.unZipFile(template.getInputStream(), dir, this.myWizard);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        ProjectManager.getDefault().clearNonProjectCache();
        Project createdProject = FileOwnerQuery.getOwner((FileObject)dir);
        assert (createdProject != null) : "crated project is null";
        JavaMELibsConfigurationHelper.configureJavaMELibs(createdProject, this.myWizard);
        CustomComponentWizardIterator.configureComponents(createdProject, this.myWizard);
        return resultSet;
    }

    private FileObject getProjectTemplate(WizardDescriptor wizard) {
        if (BaseHelper.isNetBeansOrg(wizard)) {
            assert (false) : "should not have been allowed to continue";
        } else {
            if (BaseHelper.isSuiteComponent(wizard)) {
                return BaseHelper.getTemplate(TEMPLATE_PROJECT_SUITECOMPONENT);
            }
            if (BaseHelper.isStandalone(wizard)) {
                return BaseHelper.getTemplate(TEMPLATE_PROJECT_STANDALONE);
            }
        }
        throw new IllegalArgumentException("unsupported wizard type");
    }

    public void initialize(WizardDescriptor wiz) {
        this.myWizard = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty(SELECTED_INDEX, new Integer(i));
            jc.putClientProperty(CONTENT_DATA, steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        wiz.putProperty(PROJECT_DIR, null);
        wiz.putProperty(PROJECT_NAME, null);
        wiz.putProperty(LIBRARIES, null);
        wiz.putProperty(LIB_NAMES, null);
        wiz.putProperty(LIB_DISPLAY_NAMES, null);
        wiz.putProperty(CUSTOM_COMPONENTS, null);
        wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(CustomComponentWizardIterator.class).getString(LBL_WIZARD_STEPS_COUNT), new Integer(this.index + 1) + "", new Integer(this.panels.length) + "");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static Set<FileObject> configureComponents(Project project, WizardDescriptor wizard) throws IOException {
        List components = (List)wizard.getProperty(CUSTOM_COMPONENTS);
        if (components == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        for (Map component : components) {
            CustomComponentHelper.RealInstantiationHelper helper = new CustomComponentHelper.RealInstantiationHelper(project, component);
            resultSet.addAll(((CustomComponentHelper)helper).instantiate());
        }
        return Collections.EMPTY_SET;
    }
}

