/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public class JcBasicParser
extends BasicParser {
    private static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/cli/messages");
    private Options options;

    public CommandLine parse(Options options, String[] stringArray, boolean bl) throws ParseException {
        this.options = options;
        List<String> list = Arrays.asList(this.flatten(options, stringArray, bl));
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = listIterator.next();
            if (!string.startsWith("-") || this.options.hasOption(string)) continue;
            throw new UnrecognizedOptionException(MessageFormat.format(messages.getString("option.unrecognized"), string));
        }
        return super.parse(options, stringArray, bl);
    }

    public void processArgs(Option option, ListIterator listIterator) throws ParseException {
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (this.options.hasOption(string) && string.startsWith("-")) {
                listIterator.previous();
                break;
            }
            if (option.addValue(string)) continue;
            listIterator.previous();
            break;
        }
        if (option.getValues() == null && !option.hasOptionalArg()) {
            throw new MissingArgumentException(MessageFormat.format(messages.getString("argument.missed"), option.getOpt(), option.getLongOpt()));
        }
    }
}

