/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.formatting;

import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.formatting.api.support.MarkupAbstractIndenter;
import org.netbeans.modules.editor.indent.spi.Context;

public class JspIndenter
extends MarkupAbstractIndenter<JspTokenId> {
    public JspIndenter(Context context) {
        super(JspTokenId.language(), context);
    }

    protected boolean isWhiteSpaceToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.WHITESPACE || token.id() == JspTokenId.TEXT && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected boolean isOpenTagNameToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.TAG;
    }

    protected boolean isCloseTagNameToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.ENDTAG;
    }

    protected boolean isStartTagSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && (((Object)token.text()).toString().equals("<") || ((Object)token.text()).toString().equals("<%@"));
    }

    protected boolean isStartTagClosingSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && ((Object)token.text()).toString().equals("</");
    }

    protected boolean isEndTagSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && ((Object)token.text()).toString().equals(">");
    }

    protected boolean isEndTagClosingSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && (((Object)token.text()).toString().equals("/>") || ((Object)token.text()).toString().equals("%>"));
    }

    protected boolean isTagArgumentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.ATTRIBUTE;
    }

    protected boolean isBlockCommentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.COMMENT;
    }

    protected boolean isTagContentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.TEXT;
    }

    protected boolean isClosingTagOptional(CharSequence tagName) {
        return false;
    }

    protected boolean isOpeningTagOptional(CharSequence tagName) {
        return false;
    }

    protected Boolean isEmptyTag(CharSequence tagName) {
        return null;
    }

    protected boolean isTagContentUnformattable(CharSequence tagName) {
        return false;
    }

    protected Set<String> getTagChildren(CharSequence tagName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isPreservedLine(Token<JspTokenId> token, IndenterContextData<JspTokenId> context) {
        String text = ((Object)token.text()).toString().trim();
        return token.id() == JspTokenId.COMMENT && !text.startsWith("<%--") && !text.startsWith("--%>");
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<JspTokenId> ts) throws BadLocationException {
        int[] index = ts.index();
        boolean found = false;
        while (ts.token().id() == JspTokenId.COMMENT) {
            String comment = ((Object)ts.token().text()).toString().trim();
            if (comment.startsWith("<%--")) {
                found = true;
                break;
            }
            if (ts.movePrevious()) continue;
        }
        int indent = 0;
        if (found) {
            int lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)ts.offset());
            int column = ts.offset();
            indent = column - lineStart;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return indent;
    }

    protected boolean isForeignLanguageStartToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> ts) {
        return token.id() == JspTokenId.SYMBOL2 && (((Object)token.text()).toString().equals("<%") || ((Object)token.text()).toString().equals("<%=") || ((Object)token.text()).toString().equals("<%!"));
    }

    protected boolean isForeignLanguageEndToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> ts) {
        return token.id() == JspTokenId.SYMBOL2 && ((Object)token.text()).toString().equals("%>");
    }

    protected boolean isStableFormattingStartToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> ts) {
        return token.id() == JspTokenId.SYMBOL2 && (((Object)token.text()).toString().equals("<%") || ((Object)token.text()).toString().equals("<%=") || ((Object)token.text()).toString().equals("<%!"));
    }
}

