/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.stdout.spi;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.stdout.CLIODCConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.collector.stdout.impl.CLIODCConfigurationAccessor;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListenersSupport;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class CLIODataCollector
extends IndicatorDataProvider<CLIODCConfiguration>
implements DataCollector<CLIODCConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private static final Logger log = DLightLogger.getLogger(CLIODataCollector.class);
    private String command;
    private final Map<String, String> envs;
    private String argsTemplate;
    private DataStorage storage;
    private Future<Integer> collectorTask;
    private CLIOParser parser;
    private final DataStorageType dataStorageType;
    private final String firstTableName;
    private final List<DataTableMetadata> metadata;
    private final DataCollectorListenersSupport dclsupport = new DataCollectorListenersSupport((DataCollector)this);

    CLIODataCollector(CLIODCConfiguration configuration) {
        super(CLIODataCollector.constructName(configuration));
        CLIODCConfigurationAccessor accessor = CLIODCConfigurationAccessor.getDefault();
        this.command = accessor.getCommand(configuration);
        this.argsTemplate = accessor.getArguments(configuration);
        this.parser = accessor.getParser(configuration);
        this.envs = accessor.getDLightTargetExecutionEnv(configuration);
        this.dataStorageType = accessor.getDataStorageType(configuration);
        this.metadata = Collections.unmodifiableList(accessor.getDataTablesMetadata(configuration));
        this.firstTableName = this.metadata != null && !this.metadata.isEmpty() ? this.metadata.get(0).getName() : null;
    }

    public final void addDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.addListener(listener);
    }

    public final void removeDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.removeListener(listener);
    }

    protected final void notifyListeners(DataCollector.CollectorState state) {
        this.dclsupport.notifyListeners(state);
    }

    private static String constructName(CLIODCConfiguration configuration) {
        String cmd = CLIODCConfigurationAccessor.getDefault().getCommand(configuration);
        int separatorIndex = cmd.lastIndexOf(File.separator);
        return separatorIndex == -1 || separatorIndex == cmd.length() - 1 ? cmd : cmd.substring(separatorIndex + 1);
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Arrays.asList(this.dataStorageType);
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        this.storage = storages.get(this.dataStorageType);
        log.log(Level.FINE, "Do INIT for {0}", this.storage.toString());
    }

    protected void processLine(String line) {
        DataRow dataRow = this.parser.process(line);
        if (dataRow != null) {
            if (this.firstTableName != null && this.storage != null) {
                this.storage.addData(this.firstTableName, Arrays.asList(dataRow));
            }
            this.notifyIndicators(Arrays.asList(dataRow));
        }
    }

    protected void targetStarted(DLightTarget target) {
        log.log(Level.FINE, "Starting CLIODataCollector: {0}", this.command);
        this.resetIndicators();
        String cmd = this.command + " ";
        if (target instanceof AttachableTarget) {
            AttachableTarget at = (AttachableTarget)target;
            cmd = cmd + this.argsTemplate.replaceAll("@PID", "" + at.getPID());
        } else {
            cmd = cmd + this.argsTemplate;
        }
        log.log(Level.FINE, "Starting CLIODataCollector cmd: {0}", cmd);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)target.getExecEnv());
        npb.setCommandLine(cmd);
        ExecutionDescriptor descriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new CLIOInputProcessorFactory()).errProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new CLIOInputProcessorFactory());
        ExecutionService execService = ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descriptor, (String)("CLIODataCollector " + cmd));
        this.collectorTask = execService.run();
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.RUNNING);
                try {
                    CLIODataCollector.this.collectorTask.get();
                }
                catch (InterruptedException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                catch (ExecutionException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                catch (CancellationException ex) {
                    CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.TERMINATED);
                    return;
                }
                CLIODataCollector.this.notifyListeners(DataCollector.CollectorState.STOPPED);
            }
        }, (String)"Listen for the CLIO task");
    }

    protected void targetFinished(DLightTarget target) {
        if (this.collectorTask != null && !this.collectorTask.isDone()) {
            log.log(Level.FINE, "Stopping CLIODataCollector: {0}", this.collectorTask.toString());
            this.collectorTask.cancel(true);
        }
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.metadata;
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(CLIODataCollector.class, (String)key, (Object[])params);
    }

    protected ValidationStatus doValidation(DLightTarget target) {
        DLightLogger.assertNonUiThread();
        ValidationStatus result = null;
        boolean fileExists = false;
        boolean connected = true;
        ExecutionEnvironment execEnv = target.getExecEnv();
        String error = "";
        try {
            fileExists = HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)this.command);
        }
        catch (InterruptedException ex) {
            error = CLIODataCollector.loc("ValidationStatus.InterruptedWhileValidation", new String[0]);
            return ValidationStatus.invalidStatus((String)error);
        }
        catch (IOException ex) {
            error = ex.getMessage();
            connected = false;
        }
        if (connected) {
            result = fileExists ? ValidationStatus.validStatus() : ValidationStatus.invalidStatus((String)CLIODataCollector.loc("ValidationStatus.CommandNotFound", this.command));
        } else {
            ConnectionManager mgr = ConnectionManager.getInstance();
            Runnable doOnConnect = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction connectAction = mgr.getConnectToAction(execEnv, doOnConnect);
            result = ValidationStatus.unknownStatus((String)CLIODataCollector.loc("ValidationStatus.ErrorWhileValidation", error), (AsynchronousAction)connectAction);
        }
        return result;
    }

    public void setupEnvironment(DLightTarget target, MacroMap env) {
        env.putAll(this.envs);
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    private class CLIOInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private CLIOInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    CLIODataCollector.this.processLine(line);
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }
    }
}

