/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InjectCompositeComponent {
    private static final int HINT_PRIORITY = 60;
    private static final String TEMPLATES_FOLDER = "JSF";
    private static final String TEMPLATE_NAME = "out.xhtml";
    private static final Rule injectCCRule = new InjectCCSelectionRule();

    public static void inject(Document document, int from, int to) {
        try {
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            InjectCompositeComponent.instantiateTemplate(project, fileObject, document, from, to);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static Hint getHint(final RuleContext context, final int from, final int to) {
        return new Hint(injectCCRule, NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentSelectionHintDescription"), context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(from, to), Collections.singletonList(new HintFix(){

            public String getDescription() {
                return NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentSelectionHintDescription");
            }

            public void implement() throws Exception {
                InjectCompositeComponent.inject((Document)context.doc, from, to);
            }

            public boolean isSafe() {
                return true;
            }

            public boolean isInteractive() {
                return true;
            }
        }), 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instantiateTemplate(Project project, FileObject file, final Document document, final int startOffset, final int endOffset) throws BadLocationException, DataObjectNotFoundException, IOException, ParseException {
        String selectedText = startOffset == endOffset ? null : document.getText(startOffset, endOffset - startOffset);
        TemplateWizard templateWizard = new TemplateWizard();
        templateWizard.putProperty("project", (Object)project);
        templateWizard.putProperty("selectedText", (Object)selectedText);
        templateWizard.setTitle(NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InsertCompositeComponent"));
        templateWizard.putProperty("fromEditor", (Object)true);
        DataFolder templatesFolder = templateWizard.getTemplatesFolder();
        FileObject template = templatesFolder.getPrimaryFile().getFileObject("JSF/out.xhtml");
        FileObject projectDir = project.getProjectDirectory();
        DataFolder targetFolder = DataFolder.findFolder((FileObject)projectDir);
        final Logger logger = Logger.getLogger(InjectCompositeComponent.class.getSimpleName());
        final JsfSupportImpl jsfs = JsfSupportImpl.findFor(file);
        if (jsfs == null) {
            logger.warning("Cannot find JsfSupport instance for file " + file.getPath());
            return;
        }
        final SnippetContext context = InjectCompositeComponent.getSnippetContext(document, startOffset, endOffset, jsfs);
        if (!context.isValid()) {
            templateWizard.putProperty("incorrectActionContext", (Object)true);
        }
        Source source = Source.create((Document)document);
        final AtomicReference declaredPrefixes = new AtomicReference();
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                HtmlParserResult result;
                ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (ri != null && (result = (HtmlParserResult)ri.getParserResult()) != null) {
                    declaredPrefixes.set(result.getNamespaces());
                }
            }
        });
        templateWizard.putProperty("declaredPrefixes", declaredPrefixes.get());
        DataObject templateDO = DataObject.find((FileObject)template);
        Set result = templateWizard.instantiate(templateDO, targetFolder);
        final String prefix = (String)templateWizard.getProperty("selectedPrefix");
        if (result != null && result.size() > 0) {
            final String compName = ((DataObject)result.iterator().next()).getName();
            FileObject tF = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            final BaseDocument doc = (BaseDocument)document;
            final Indent indent = Indent.get((Document)doc);
            indent.lock();
            try {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(startOffset, endOffset - startOffset);
                            String text = "<" + prefix + ":" + compName + "/>";
                            doc.insertString(startOffset, text, null);
                            indent.reindent(startOffset, startOffset + text.length());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
            String compFolder = tF.getPath();
            compFolder = FileUtil.getRelativePath((FileObject)projectDir, (FileObject)tF);
            if (compFolder.endsWith(File.separator)) {
                compFolder = compFolder.substring(0, compFolder.lastIndexOf(File.separator));
            }
            compFolder = compFolder.substring(compFolder.lastIndexOf(File.separator) + 1);
            final String compositeLibURL = LibraryUtils.getCompositeLibraryURL((String)compFolder);
            Source documentSource = Source.create((Document)document);
            ParserManager.parseWhenScanFinished(Collections.singletonList(documentSource), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    AbstractFaceletsLibrary lib = jsfs.getLibraries().get(compositeLibURL);
                    if (lib != null) {
                        if (!LibraryUtils.importLibrary((Document)document, (Library)lib, (String)prefix)) {
                            logger.warning("Cannot import composite components library " + compositeLibURL);
                        }
                    } else {
                        logger.warning("Composite components library for uri " + compositeLibURL + " seems not to be created.");
                    }
                }
            });
            DataObject templateInstance = (DataObject)result.iterator().next();
            EditorCookie ec = (EditorCookie)templateInstance.getCookie(EditorCookie.class);
            final StyledDocument templateInstanceDoc = ec.openDocument();
            ParserManager.parseWhenScanFinished(Collections.singletonList(documentSource), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    final LinkedHashMap<Library, String> importsMap = new LinkedHashMap<Library, String>();
                    for (String uri : context.getDeclarations().keySet()) {
                        String prefix = context.getDeclarations().get(uri);
                        Library lib = jsfs.getLibraries().get(uri);
                        if (lib == null) continue;
                        importsMap.put(lib, prefix);
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ((BaseDocument)templateInstanceDoc).runAtomic(new Runnable(){

                                @Override
                                public void run() {
                                    LibraryUtils.importLibrary((Document)templateInstanceDoc, (Map)importsMap);
                                }
                            });
                        }
                    });
                }
            });
            ec.saveDocument();
        }
    }

    private static SnippetContext getSnippetContext(Document doc, final int from, final int to, final JsfSupportImpl jsfs) {
        final SnippetContext context = new SnippetContext();
        context.setValid(true);
        Source source = Source.create((Document)doc);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    final HtmlParserResult result = (HtmlParserResult)JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (result == null) {
                        return;
                    }
                    final int astFrom = result.getSnapshot().getEmbeddedOffset(from);
                    final int astTo = result.getSnapshot().getEmbeddedOffset(to);
                    try {
                        for (final String libUri : result.getNamespaces().keySet()) {
                            if (!jsfs.getLibraries().containsKey(libUri)) continue;
                            AstNode root = result.root(libUri);
                            AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)new AstNodeVisitor(){

                                public void visit(AstNode node) {
                                    AstNode closeTag;
                                    int node_logical_from = node.logicalStartOffset();
                                    int node_logical_to = node.logicalEndOffset();
                                    if (node_logical_from >= astFrom && node_logical_from <= astTo || node_logical_to >= astFrom && node_logical_to <= astTo) {
                                        context.addDeclaration(libUri, (String)result.getNamespaces().get(libUri));
                                    }
                                    if (astFrom > node_logical_from && astFrom < node_logical_to && (astTo <= node_logical_from || astTo >= node_logical_to) || astTo > node_logical_from && astTo < node_logical_to && (astFrom <= node_logical_from || astFrom >= node_logical_to)) {
                                        this.fail();
                                    }
                                    if ((closeTag = node.getMatchingTag()) == null && !node.isEmpty()) {
                                        this.fail();
                                    }
                                    if (this.isInTagItself(node, astFrom) || this.isInTagItself(node, astTo) || this.isInTagItself(closeTag, astFrom) || this.isInTagItself(closeTag, astTo)) {
                                        this.fail();
                                    }
                                }

                                private boolean isInTagItself(AstNode node, int offset) {
                                    return node != null && node.startOffset() < offset && node.endOffset() > offset;
                                }

                                private void fail() {
                                    context.setValid(false);
                                    throw new AstTreeVisitingBreakException();
                                }
                            }, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
                        }
                    }
                    catch (AstTreeVisitingBreakException e) {
                        context.setValid(false);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return context;
    }

    public static class InjectCCCodeGen
    implements CodeGenerator {
        public String getDisplayName() {
            return NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentHint");
        }

        public void invoke() {
            JTextComponent textComponent = EditorRegistry.lastFocusedComponent();
            Document doc = textComponent.getDocument();
            int from = textComponent.getSelectionStart();
            int to = textComponent.getSelectionEnd();
            InjectCompositeComponent.inject(doc, from, to);
        }
    }

    private static class InjectCCSelectionRule
    implements Rule.SelectionRule {
        private InjectCCSelectionRule() {
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return null;
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.CURRENT_LINE_WARNING;
        }
    }

    private static class SnippetContext {
        private boolean valid;
        private Map<String, String> relatedDeclarations = new HashMap<String, String>();

        private SnippetContext() {
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public void addDeclaration(String uri, String prefix) {
            this.relatedDeclarations.put(uri, prefix);
        }

        public Map<String, String> getDeclarations() {
            return this.relatedDeclarations;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static class AstTreeVisitingBreakException
    extends RuntimeException {
        private AstTreeVisitingBreakException() {
        }
    }
}

