/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.node.ColumnNameProvider;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Tuple;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class ColumnNode
extends BaseNode
implements SchemaNameProvider,
ColumnNameProvider {
    private static final String COLUMN = "org/netbeans/modules/db/resources/column.gif";
    private static final String PRIMARY = "org/netbeans/modules/db/resources/columnPrimary.gif";
    private static final String INDEX = "org/netbeans/modules/db/resources/columnIndex.gif";
    private static final String FOLDER = "Column";
    private static final String TOOLTIP_COLUMN = NbBundle.getMessage(ColumnNode.class, (String)"ND_Column");
    private static final String TOOLTIP_PRIMARY = NbBundle.getMessage(ColumnNode.class, (String)"ND_PrimaryKey");
    private static final String TOOLTIP_INDEX = NbBundle.getMessage(ColumnNode.class, (String)"ND_Index");
    private static final Logger LOG = Logger.getLogger(ColumnNode.class.getName());
    private String name = "";
    private String icon;
    private String description = TOOLTIP_COLUMN;
    private final MetadataElementHandle<Column> columnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private boolean isTableColumn = true;

    public static ColumnNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ColumnNode node = new ColumnNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ColumnNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
    }

    @Override
    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    @Override
    protected void initialize() {
        this.setupNames();
    }

    private void setupNames() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Column column = (Column)ColumnNode.this.columnHandle.resolve(metaData);
                        if (column != null) {
                            ColumnNode.this.name = column.getName();
                            ColumnNode.this.icon = ColumnNode.COLUMN;
                            ColumnNode.this.updateProperties(column);
                            Tuple tuple = column.getParent();
                            if (tuple instanceof Table) {
                                Table table = (Table)tuple;
                                PrimaryKey pkey = table.getPrimaryKey();
                                boolean found = false;
                                if (pkey != null) {
                                    Collection columns = pkey.getColumns();
                                    for (Column c : columns) {
                                        if (c == null || !column.getName().equals(c.getName())) continue;
                                        found = true;
                                        ColumnNode.this.icon = ColumnNode.PRIMARY;
                                        ColumnNode.this.description = TOOLTIP_PRIMARY;
                                        break;
                                    }
                                }
                                if (!found) {
                                    Collection indexes = table.getIndexes();
                                    block1: for (Index index : indexes) {
                                        Collection columns = index.getColumns();
                                        for (IndexColumn c : columns) {
                                            if (!c.getName().equals(column.getName())) continue;
                                            found = true;
                                            ColumnNode.this.icon = ColumnNode.INDEX;
                                            ColumnNode.this.description = TOOLTIP_INDEX;
                                            continue block1;
                                        }
                                    }
                                }
                            } else {
                                ColumnNode.this.isTableColumn = false;
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Column column) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        assert (column != null) : "Column " + this + " cannot be null.";
        if (column == null) {
            return;
        }
        try {
            int len;
            this.addProperty("Null", "NullDescription", Boolean.class, false, column.getNullable() == Nullable.NULLABLE);
            if (column.getType() != null) {
                this.addProperty("Datatype", "DatatypeDescription", String.class, false, column.getType().toString());
            }
            if ((len = column.getLength()) == 0) {
                len = column.getPrecision();
            }
            this.addProperty("ColumnSize", "ColumnSizeDescription", Integer.class, false, len);
            this.addProperty("DecimalDigits", "DecimalDigitsDescription", Short.class, false, column.getScale());
            this.addProperty("Position", "PositionDescription", Integer.class, false, column.getPosition());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
    }

    @Override
    public String getColumnName() {
        return ColumnNode.getColumnName(this.connection, this.columnHandle);
    }

    @Override
    public String getSchemaName() {
        return ColumnNode.getSchemaName(this.connection, this.columnHandle);
    }

    @Override
    public String getCatalogName() {
        return ColumnNode.getCatalogName(this.connection, this.columnHandle);
    }

    @Override
    public String getParentName() {
        return ColumnNode.getParentName(this.connection, this.columnHandle);
    }

    public int getPosition() {
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        final int[] array = new int[]{1};
        if (metaDataModel == null) {
            LOG.log(Level.INFO, "Null MetadataModel for " + this.connection);
            return array[0];
        }
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Column column = (Column)ColumnNode.this.columnHandle.resolve(metaData);
                    if (column != null) {
                        array[0] = column.getPosition();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
        }
        return array[0];
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        Specification spec = connector.getDatabaseSpecification();
        try {
            RemoveColumn command = spec.createCommandRemoveColumn(this.getParentName());
            String schema = this.getSchemaName();
            if (schema == null) {
                schema = this.getCatalogName();
            }
            command.setObjectOwner(schema);
            command.removeColumn(this.getName());
            command.execute();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{this.getParentNode()});
    }

    @Override
    public boolean canDestroy() {
        if (this.isTableColumn) {
            DatabaseConnector connector = this.connection.getConnector();
            return connector.supportsCommand("RemoveColumnCommand");
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return this.icon;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable result = ExTransferable.create((Transferable)super.clipboardCopy());
        result.put(new ExTransferable.Single(DatabaseMetaDataTransfer.COLUMN_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createColumnData(ColumnNode.this.connection.getDatabaseConnection(), ColumnNode.this.connection.findJDBCDriver(), ColumnNode.this.getParentName(), ColumnNode.this.getName());
            }
        });
        return result;
    }

    public String getShortDescription() {
        return this.description;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ColumnNode.class);
    }

    public static String getColumnName(DatabaseConnection connection, final MetadataElementHandle<Column> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[]{null};
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Column column = (Column)handle.resolve(metaData);
                    if (column != null) {
                        array[0] = column.getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ColumnNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getParentName(DatabaseConnection connection, final MetadataElementHandle<Column> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[]{null};
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Column column = (Column)handle.resolve(metaData);
                    if (column != null) {
                        array[0] = column.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ColumnNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getSchemaName(DatabaseConnection connection, final MetadataElementHandle<Column> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Column column = (Column)handle.resolve(metaData);
                    if (column != null) {
                        array[0] = column.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ColumnNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getCatalogName(DatabaseConnection connection, final MetadataElementHandle<Column> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    Column column = (Column)handle.resolve(metaData);
                    if (column != null) {
                        array[0] = column.getParent().getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ColumnNode.class, connection, e, true);
        }
        return array[0];
    }
}

