/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerPackageProvider;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.packages.TestPackageProvider;

public final class TracerSupportImpl {
    private static TracerSupportImpl INSTANCE;
    private final Set<TracerPackageProvider> providers = new HashSet<TracerPackageProvider>();

    public static synchronized TracerSupportImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TracerSupportImpl();
        }
        return INSTANCE;
    }

    public synchronized void registerPackageProvider(TracerPackageProvider provider) {
        this.providers.add(provider);
    }

    public synchronized void unregisterPackageProvider(TracerPackageProvider provider) {
        this.providers.remove(provider);
    }

    public synchronized boolean hasPackages(Object target) {
        for (TracerPackageProvider provider : this.providers) {
            if (!provider.getScope().isInstance(target)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<TracerPackage> getPackages(IdeSnapshot snapshot) {
        ArrayList<TracerPackage> packages = new ArrayList<TracerPackage>();
        for (TracerPackageProvider provider : this.providers) {
            packages.addAll(Arrays.asList(provider.getPackages(snapshot)));
        }
        Collections.sort(packages, Positionable.COMPARATOR);
        return packages;
    }

    private TracerSupportImpl() {
        this.registerPackageProvider(new TestPackageProvider());
    }
}

