/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.util.HgCommand;

public class HgLogMessage {
    public static char HgModStatus = (char)77;
    public static char HgAddStatus = (char)65;
    public static char HgDelStatus = (char)82;
    public static char HgCopyStatus = (char)67;
    private List<HgLogMessageChangedPath> paths;
    private HgRevision rev;
    private String author;
    private String username;
    private String desc;
    private Date date;
    private String timeZoneOffset;
    private HgRevision parentOneRev;
    private HgRevision parentTwoRev;
    private boolean bMerged;
    private String rootURL;
    private OutputLogger logger;
    private HashMap<File, HgRevision> ancestors = new HashMap();

    private void updatePaths(List<String> pathsStrings, String path, List<String> filesShortPaths, char status) {
        if (filesShortPaths.isEmpty()) {
            this.paths.add(new HgLogMessageChangedPath(path, status));
            if (pathsStrings != null) {
                pathsStrings.add(path);
            }
        } else {
            this.paths.add(new HgLogMessageChangedPath(path, status));
            if (pathsStrings != null) {
                pathsStrings.add(path);
            }
        }
    }

    public HgLogMessage(String rootURL, List<String> filesShortPaths, String rev, String auth, String username, String desc, String date, String id, String parents, String fm, String fa, String fd, String fc) {
        String[] parentSplits;
        this.rootURL = rootURL;
        this.rev = new HgRevision(id, rev);
        this.author = auth;
        this.username = username;
        this.desc = desc;
        this.date = new Date(Long.parseLong(date.split(" ")[0]) * 1000L);
        String[] stringArray = parentSplits = parents != null ? parents.split(" ") : null;
        if (parentSplits != null && parentSplits.length == 2) {
            this.parentOneRev = this.createRevision(parentSplits[0]);
            this.parentTwoRev = this.createRevision(parentSplits[1]);
        }
        this.bMerged = this.parentOneRev != null && this.parentTwoRev != null && !this.parentOneRev.getRevisionNumber().equals("-1") && !this.parentTwoRev.getRevisionNumber().equals("-1");
        this.paths = new ArrayList<HgLogMessageChangedPath>();
        ArrayList<String> apathsStrings = new ArrayList<String>();
        ArrayList<String> dpathsStrings = new ArrayList<String>();
        ArrayList<String> cpathsStrings = new ArrayList<String>();
        if (fc != null && !fc.equals("")) {
            for (String s : fc.split("\t")) {
                this.updatePaths(cpathsStrings, s, filesShortPaths, HgCopyStatus);
            }
        }
        if (fa != null && !fa.equals("")) {
            for (String s : fa.split("\t")) {
                if (cpathsStrings.contains(s)) continue;
                this.updatePaths(apathsStrings, s, filesShortPaths, HgAddStatus);
            }
        }
        if (fd != null && !fd.equals("")) {
            for (String s : fd.split("\t")) {
                this.updatePaths(dpathsStrings, s, filesShortPaths, HgDelStatus);
            }
        }
        if (fm != null && !fm.equals("")) {
            for (String s : fm.split("\t")) {
                if (apathsStrings.contains(s) || dpathsStrings.contains(s) || cpathsStrings.contains(s)) continue;
                this.updatePaths(null, s, filesShortPaths, HgModStatus);
            }
        }
        if (fa == null && fc == null && fd == null && fm == null) {
            for (String fileSP : filesShortPaths) {
                this.paths.add(new HgLogMessageChangedPath(fileSP, ' '));
            }
        }
    }

    HgLogMessageChangedPath[] getChangedPaths() {
        return this.paths.toArray(new HgLogMessageChangedPath[this.paths.size()]);
    }

    public String getRevisionNumber() {
        return this.rev.getRevisionNumber();
    }

    public long getRevisionAsLong() {
        long revLong;
        try {
            revLong = Long.parseLong(this.rev.getRevisionNumber());
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
        return revLong;
    }

    public HgRevision getHgRevision() {
        return this.rev;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCSetShortID() {
        return this.rev.getChangesetId();
    }

    public HgRevision getAncestor(File file) {
        HgRevision ancestor = this.getAncestorFromMap(file);
        if (ancestor != null) {
            return ancestor;
        }
        if (this.bMerged) {
            try {
                ancestor = HgCommand.getCommonAncestor(this.rootURL, this.parentOneRev.getRevisionNumber(), this.parentTwoRev.getRevisionNumber(), this.getLogger());
            }
            catch (HgException ex) {
                Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
                return HgRevision.EMPTY;
            }
        }
        if (this.parentOneRev != null) {
            ancestor = this.parentOneRev;
        } else {
            try {
                ancestor = HgCommand.getParent(new File(this.rootURL), file, this.rev.getRevisionNumber());
            }
            catch (HgException ex) {
                Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
                return HgRevision.EMPTY;
            }
            if (ancestor == null) {
                try {
                    Integer.toString(Integer.parseInt(this.rev.getRevisionNumber()) - 1);
                }
                catch (NumberFormatException ex) {
                    ancestor = HgRevision.EMPTY;
                }
            }
        }
        this.addAncestorToMap(file, ancestor);
        return ancestor;
    }

    private OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Mercurial.getInstance().getLogger(this.rootURL);
        }
        return this.logger;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rev: ");
        sb.append(this.rev.getRevisionNumber());
        sb.append("\nauthor: ");
        sb.append(this.author);
        sb.append("\ndesc: ");
        sb.append(this.desc);
        sb.append("\ndate: ");
        sb.append(this.date);
        sb.append("\nid: ");
        sb.append(this.rev.getChangesetId());
        sb.append("\npaths: ");
        sb.append(this.paths);
        return sb.toString();
    }

    private void addAncestorToMap(File file, HgRevision ancestor) {
        this.ancestors.put(file, ancestor);
    }

    private HgRevision getAncestorFromMap(File file) {
        return this.ancestors.get(file);
    }

    private HgRevision createRevision(String revisionString) {
        String[] ps1 = revisionString.split(":");
        String revisionNumber = ps1 != null && ps1.length >= 1 ? ps1[0] : null;
        String changesetId = ps1 != null && ps1.length >= 2 ? ps1[1] : revisionNumber;
        return revisionNumber == null ? null : new HgRevision(changesetId, revisionNumber);
    }

    public static class HgRevision {
        private final String changesetId;
        private final String revisionNumber;
        public static final HgRevision EMPTY = new HgRevision("-1", "-1");
        public static final HgRevision BASE = new HgRevision("BASE", "BASE");
        public static final HgRevision CURRENT = new HgRevision("LOCAL", "LOCAL");

        public HgRevision(String changesetId, String revisionNumber) {
            this.changesetId = changesetId;
            this.revisionNumber = revisionNumber;
        }

        public String getChangesetId() {
            return this.changesetId;
        }

        public String getRevisionNumber() {
            return this.revisionNumber;
        }
    }
}

