/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.diff.DiffFileTable;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class MultiDiffPanel
extends JPanel
implements ActionListener,
DiffSetupSource,
PropertyChangeListener,
PreferenceChangeListener {
    private Setup[] setups;
    private EditorCookie[] editorCookies;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final DiffLookup lookup = new DiffLookup();
    private final VCSContext context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentIndex = -1;
    private int currentModelIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private JComponent diffView;
    private DiffFileTable fileTable;
    private boolean dividerSet;
    private final PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    private HgProgressSupport executeStatusSupport;
    private boolean fileTableSetSelectedIndexContext;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JSplitPane splitPane;

    public MultiDiffPanel(VCSContext context, int initialType, String contextName) {
        this.context = context;
        this.contextName = contextName;
        this.currentType = initialType;
        this.initComponents();
        this.setAquaBackground();
        this.diffViewPanel = null;
        this.initFileTable();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.refreshComponents();
        this.refreshTask = Utils.createTask((Runnable)new RefreshViewTask());
        this.refreshStatuses();
    }

    private void setAquaBackground() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.controlsToolBar.setBackground(color);
            this.jPanel1.setBackground(color);
            this.jPanel2.setBackground(color);
            this.jPanel4.setBackground(color);
            this.jPanel5.setBackground(color);
        }
    }

    public MultiDiffPanel(File file, HgLogMessage.HgRevision rev1, HgLogMessage.HgRevision rev2, boolean forceNonEditable) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setAquaBackground();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.initToolbarButtons();
        this.initNextPrevActions();
        AbstractDiffSetup[] localSetups = new Setup[]{new Setup(file, rev1, rev2, forceNonEditable)};
        this.setSetups((Setup[])localSetups, DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups));
        this.setDiffIndex(0, 0, false);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = Mercurial.getInstance().getRequestProcessor().post((Runnable)this.dpt);
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.removeAll();
        this.splitPane = null;
        this.setLayout(new BorderLayout());
        this.controlsToolBar.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.add((Component)this.controlsToolBar, "North");
        this.add((Component)replacement, "Center");
    }

    private void setSetups(Setup[] setups, EditorCookie[] editorCookies) {
        this.setups = setups;
        this.editorCookies = editorCookies;
    }

    public void tableRowSelected(int viewIndex) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(viewIndex, 0, true);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    boolean canClose() {
        if (this.setups == null) {
            return true;
        }
        SaveCookie[] saveCookies = this.getSaveCookies(true);
        return saveCookies.length == 0 || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies);
    }

    public SaveCookie[] getSaveCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        return saveCookies;
    }

    public EditorCookie[] getEditorCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        int count = 0;
        int length = editorCookiesCopy.length;
        Object[] editorCookiesShorten = new EditorCookie[length];
        for (int i = 0; i < length; ++i) {
            EditorCookie editorCookie = editorCookiesCopy[i];
            if (editorCookie == null) continue;
            editorCookiesShorten[count++] = editorCookie;
        }
        return (EditorCookie[])CollectionUtils.shortenArray((Object[])editorCookiesShorten, (int)count);
    }

    private EditorCookie[] getEditorCookiesIntern(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        if (ommitOpened) {
            DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        }
        return editorCookiesCopy;
    }

    private static SaveCookie[] getSaveCookies(Setup[] setups, EditorCookie[] editorCookies) {
        assert (setups.length == editorCookies.length);
        int length = setups.length;
        Object[] proResult = new SaveCookie[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            FileObject fileObj;
            File baseFile;
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || (baseFile = setups[i].getBaseFile()) == null || (fileObj = FileUtil.toFileObject((File)baseFile)) == null) continue;
            proResult[count++] = new EditorSaveCookie(editorCookie, fileObj.getNameExt());
        }
        return (SaveCookie[])CollectionUtils.shortenArray((Object[])proResult, (int)count);
    }

    void componentClosed() {
        this.setSetups(null, null);
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    public void requestActive() {
        if (this.fileTable != null) {
            this.fileTable.getTable().requestFocusInWindow();
        } else if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void initFileTable() {
        this.fileTable = new DiffFileTable(this);
        this.splitPane.setTopComponent(this.fileTable.getComponent());
        this.splitPane.setBottomComponent(this.getInfoPanelLoading());
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.commitButton.addActionListener(this);
            this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_CommitDiff_Tooltip"));
            this.commitButton.setEnabled(false);
        } else {
            this.commitButton.setVisible(false);
            this.refreshButton.setVisible(false);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        DiffController view = this.setups != null && this.currentModelIndex != -1 ? this.setups[this.currentModelIndex].getView() : null;
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || currentDifferenceIndex > 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            Mercurial.getInstance().getFileStatusCache().addPropertyChangeListener(this);
            HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        }
        JComponent parent = (JComponent)this.getParent();
        parent.getActionMap().put("jumpNext", this.nextAction);
        parent.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void updateSplitLocation() {
        Dimension dim;
        if (this.dividerSet) {
            return;
        }
        JComponent parent = (JComponent)this.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
            return;
        }
        this.dividerSet = true;
        JTable jt = this.fileTable.getTable();
        int optimalLocation = jt.getPreferredSize().height + jt.getTableHeader().getPreferredSize().height;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= jt.getTableHeader().getPreferredSize().height) {
            optimalLocation = jt.getTableHeader().getPreferredSize().height * 3;
        }
        this.splitPane.setDividerLocation(optimalLocation);
    }

    @Override
    public void removeNotify() {
        Mercurial.getInstance().getFileStatusCache().removePropertyChangeListener(this);
        if (this.refreshTask != null) {
            HgModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        }
        super.removeNotify();
    }

    private boolean affectsView(PropertyChangeEvent event) {
        FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context == null ? false : this.context.contains(file);
    }

    private void setDiffIndex(int idx, int location, boolean restartPrepareTask) {
        this.currentIndex = idx;
        DiffController view = null;
        if (this.currentIndex != -1) {
            EditorCookie editorCookie;
            TopComponent tc;
            if (restartPrepareTask && this.dpt != null) {
                this.dpt.cancel();
                this.dpt.setTableIndex(this.currentIndex);
                this.prepareTask.schedule(100);
            }
            this.currentModelIndex = this.showingFileTable() ? this.fileTable.getModelIndex(this.currentIndex) : 0;
            view = this.setups[this.currentModelIndex].getView();
            FileObject fileObj = null;
            EditorCookie.Observable observableEditorCookie = null;
            File baseFile = this.setups[this.currentModelIndex].getBaseFile();
            if (baseFile != null) {
                fileObj = FileUtil.toFileObject((File)baseFile);
            }
            if ((tc = (TopComponent)this.getClientProperty(TopComponent.class)) != null) {
                DiffNode node = this.setups[this.currentModelIndex].getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            if ((editorCookie = this.editorCookies[this.currentModelIndex]) instanceof EditorCookie.Observable) {
                observableEditorCookie = (EditorCookie.Observable)editorCookie;
            }
            this.diffView = null;
            if (view != null) {
                if (this.showingFileTable()) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedIndex(this.currentIndex);
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
            this.lookup.setData(new Object[]{fileObj, observableEditorCookie, this.diffView.getActionMap()});
        } else {
            this.currentModelIndex = -1;
            this.lookup.setData(new Object[0]);
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.lookup.setData(new Object[]{this.diffView.getActionMap()});
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileTable() {
        return this.fileTable != null;
    }

    private void displayDiffView() {
        if (this.splitPane != null) {
            int gg = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(this.diffView);
            this.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.commitButton) {
            this.onCommitButton();
        }
    }

    private void onRefreshButton() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        if (this.context == null || this.context.getRootFiles().isEmpty()) {
            return;
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
            this.executeStatusSupport = null;
        }
        LifecycleManager.getDefault().saveAll();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        this.executeStatusSupport = new HgProgressSupport(){

            @Override
            public void perform() {
                StatusAction.executeStatus(MultiDiffPanel.this.context, this);
                MultiDiffPanel.this.refreshSetups();
            }
        };
        File repositoryRoot = HgUtils.getRootFile(this.context);
        this.executeStatusSupport.start(rp, repositoryRoot, NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_Refresh_Progress"));
    }

    private void onCommitButton() {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        if (saveCookies.length == 0 || SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
            CommitAction.commit(this.contextName, this.context);
        }
    }

    private void onNextButton() {
        DiffController view;
        if (this.showingFileTable()) {
            this.currentIndex = this.fileTable.getSelectedIndex();
            this.currentModelIndex = this.fileTable.getSelectedModelIndex();
        }
        if ((view = this.setups[this.currentModelIndex].getView()) != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (++currentDifferenceIndex >= view.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0, true);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController view = this.setups[this.currentModelIndex].getView();
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (--currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1, true);
                }
            } else if (currentDifferenceIndex < view.getDifferenceCount()) {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1, true);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        int status;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                status = 6612;
                break;
            }
            case 1: {
                status = 1696;
                break;
            }
            case 2: {
                status = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] files = HgUtils.getModifiedFiles(this.context, status, true);
        final int localDisplayStatuses = status;
        AbstractDiffSetup[] localSetups = this.computeSetups(files);
        EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups);
        Runnable runnable = new Runnable((Setup[])localSetups, cookies){
            final /* synthetic */ Setup[] val$localSetups;
            final /* synthetic */ EditorCookie[] val$cookies;
            {
                this.val$localSetups = setupArray;
                this.val$cookies = editorCookieArray;
            }

            @Override
            public void run() {
                String[] stringArray;
                MultiDiffPanel.this.dividerSet = false;
                MultiDiffPanel.this.displayStatuses = localDisplayStatuses;
                MultiDiffPanel.this.setSetups(this.val$localSetups, this.val$cookies);
                boolean propertyColumnVisible = false;
                for (Setup setup : MultiDiffPanel.this.setups) {
                    if (setup.getPropertyName() == null) continue;
                    propertyColumnVisible = true;
                    break;
                }
                DiffFileTable diffFileTable = MultiDiffPanel.this.fileTable;
                if (propertyColumnVisible) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = "name";
                    stringArray2[1] = "property";
                    stringArray2[2] = "status";
                    stringArray = stringArray2;
                    stringArray2[3] = "location";
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "name";
                    stringArray3[1] = "status";
                    stringArray = stringArray3;
                    stringArray3[2] = "location";
                }
                diffFileTable.setColumns(stringArray);
                MultiDiffPanel.this.fileTable.setTableModel(MultiDiffPanel.this.setups, MultiDiffPanel.this.editorCookies);
                if (MultiDiffPanel.this.setups.length == 0) {
                    String noContentLabel;
                    switch (MultiDiffPanel.this.currentType) {
                        case 0: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                            break;
                        }
                        case 1: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                            break;
                        }
                        case 2: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown DIFF type:" + MultiDiffPanel.this.currentType);
                        }
                    }
                    MultiDiffPanel.this.setSetups(null, null);
                    MultiDiffPanel.this.fileTable.getComponent().setEnabled(false);
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                    Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    MultiDiffPanel.this.diffView = null;
                    MultiDiffPanel.this.diffView = (JComponent)new NoContentPanel(noContentLabel);
                    MultiDiffPanel.this.displayDiffView();
                    MultiDiffPanel.this.nextAction.setEnabled(false);
                    MultiDiffPanel.this.prevAction.setEnabled(false);
                    MultiDiffPanel.this.commitButton.setEnabled(false);
                    MultiDiffPanel.this.revalidate();
                    MultiDiffPanel.this.repaint();
                } else {
                    MultiDiffPanel.this.fileTable.getComponent().setEnabled(true);
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                    Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    MultiDiffPanel.this.setDiffIndex(0, 0, false);
                    MultiDiffPanel.this.commitButton.setEnabled(true);
                    MultiDiffPanel.this.dpt = new DiffPrepareTask(MultiDiffPanel.this.setups);
                    MultiDiffPanel.this.prepareTask = Mercurial.getInstance().getRequestProcessor().post((Runnable)MultiDiffPanel.this.dpt);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
                Mercurial.LOG.log(Level.FINE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Mercurial.LOG.log(Level.FINE, null, ex);
            }
        }
    }

    private Setup[] computeSetups(File[] files) {
        ArrayList<Setup> newSetups = new ArrayList<Setup>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) continue;
            Setup setup = new Setup(file, null, this.currentType);
            setup.setNode(new DiffNode(setup, new HgFileNode(file)));
            newSetups.add(setup);
        }
        Collections.sort(newSetups, new SetupsComparator());
        return newSetups.toArray(new Setup[newSetups.size()]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            this.refreshComponents();
        } else if ("status.changed".equals(evt.getPropertyName())) {
            if (!this.affectsView(evt)) {
                return;
            }
            this.refreshTask.schedule(200);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    private void initComponents() {
        this.controlsToolBar = new JToolBar();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.jPanel4.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        this.jPanel3.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jPanel3, -2, -1, -2).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((Component)this.jPanel3, -2, -1, -2)));
        this.controlsToolBar.add(this.jPanel4);
        this.jPanel1.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 80, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel1);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 21, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.commitButton.setHorizontalTextPosition(0);
        this.commitButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.commitButton);
        this.splitPane.setOrientation(0);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.controlsToolBar, -1, 716, Short.MAX_VALUE).add((Component)this.splitPane, -1, 716, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.controlsToolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE)));
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.onRefreshButton();
    }

    static final class Property {
        final byte[] value;

        Property(Object value) {
            this.value = (byte[])value;
        }

        String getMIME() {
            return "text/plain";
        }

        Reader toReader() {
            if (HgUtils.isBinary(this.value)) {
                return new StringReader(NbBundle.getMessage(MultiDiffPanel.class, (String)"LBL_Diff_NoBinaryDiff"));
            }
            try {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.value), "utf8");
            }
            catch (UnsupportedEncodingException ex) {
                Mercurial.LOG.log(Level.SEVERE, "UnsupportedEncodingException {0}", ex);
                return new StringReader("[ERROR: " + ex.getLocalizedMessage() + "]");
            }
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            MultiDiffPanel.this.refreshSetups();
        }
    }

    private static class SetupsComparator
    implements Comparator<Setup> {
        private HgUtils.ByImportanceComparator delegate = new HgUtils.ByImportanceComparator();
        private FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();

        @Override
        public int compare(Setup setup1, Setup setup2) {
            int cmp = this.delegate.compare(this.cache.getStatus(setup1.getBaseFile()), this.cache.getStatus(setup2.getBaseFile()));
            if (cmp == 0) {
                return setup1.getBaseFile().getName().compareToIgnoreCase(setup2.getBaseFile().getName());
            }
            return cmp;
        }
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private int tableIndex;
        private boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            this.prepareSetups = prepareSetups;
            this.tableIndex = 0;
        }

        @Override
        public void run() {
            int[] indexes;
            this.canceled = false;
            IOException exception = null;
            for (int i : indexes = this.prepareIndexesToRefresh()) {
                int modelIndex;
                if (this.prepareSetups != MultiDiffPanel.this.setups || Thread.interrupted()) {
                    return;
                }
                int n = modelIndex = MultiDiffPanel.this.fileTable == null ? i : MultiDiffPanel.this.fileTable.getModelIndex(i);
                if (this.prepareSetups[modelIndex].getView() != null) continue;
                try {
                    this.prepareSetups[modelIndex].initSources();
                    final int fi = modelIndex;
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    StreamSource ss1 = this.prepareSetups[fi].getFirstSource();
                    StreamSource ss2 = this.prepareSetups[fi].getSecondSource();
                    DiffController view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    this.prepareSetups[fi].setView(view);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                return;
                            }
                            if (MultiDiffPanel.this.currentModelIndex == fi) {
                                MultiDiffPanel.this.setDiffIndex(MultiDiffPanel.this.currentIndex, 0, false);
                            }
                            if (MultiDiffPanel.this.splitPane != null) {
                                MultiDiffPanel.this.updateSplitLocation();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    if (HgUtils.isCanceled(e)) {
                        Logger.getLogger(MultiDiffPanel.class.getName()).log(Level.FINE, null, e);
                        return;
                    }
                    Mercurial.LOG.log(Level.INFO, null, e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception(exception));
            }
        }

        private int[] prepareIndexesToRefresh() {
            int index = this.tableIndex;
            int min = Math.max(0, index - 2);
            int max = Math.min(this.prepareSetups.length - 1, index + 2);
            int[] indexes = new int[max - min + 1];
            int i = index;
            int k = 0;
            for (int j = index + 1; i >= min || j <= max; --i, ++j) {
                if (i >= min) {
                    indexes[k++] = i;
                }
                if (j > max) continue;
                indexes[k++] = j;
            }
            return indexes;
        }

        private void setTableIndex(int index) {
            this.tableIndex = index;
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }
    }
}

