/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.customizer.ProjectSharability;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CustomizerProviderImpl
implements CustomizerProvider,
ProjectSharability {
    private final EarProject project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-j2ee-earproject/Customizer";

    public CustomizerProviderImpl(EarProject project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = refHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        EarProjectProperties uiProperties = new EarProjectProperties(this.project, this.project.getUpdateHelper(), this.project.evaluator(), this.project.getReferenceHelper());
        Lookup context = Lookups.fixed((Object[])new Object[]{this.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
        OptionListener listener = new OptionListener(this.project, uiProperties);
        StoreListener storeListener = new StoreListener(uiProperties);
        dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)listener, (ActionListener)storeListener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    public boolean isSharable() {
        return this.project.getAntProjectHelper().isSharableProject();
    }

    public void makeSharable() {
        EarProjectProperties uiProperties = new EarProjectProperties(this.project, this.project.getUpdateHelper(), this.project.evaluator(), this.project.getReferenceHelper());
        if (this.project.getAntProjectHelper().isSharableProject()) {
            assert (false) : "Project " + this.project + " is already sharable.";
            return;
        }
        String[] serverLibraryName = new String[1];
        CustomizerLibraries.makeSharable(uiProperties, serverLibraryName);
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private EarProjectProperties uiProperties;

        OptionListener(Project project, EarProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private class StoreListener
    implements ActionListener {
        private EarProjectProperties uiProperties;

        StoreListener(EarProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.uiProperties.store();
        }
    }
}

