/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.openide.filesystems.FileObject;

public abstract class Crawler {
    private final URL root;
    private final boolean checkTimeStamps;
    private final boolean supportsAllFiles;
    private final TimeStamps timeStamps;
    private final CancelRequest cancelRequest;
    private Collection<IndexableImpl> resources;
    private Collection<IndexableImpl> allResources;
    private Collection<IndexableImpl> deleted;
    private boolean finished;
    private boolean changed;
    private boolean initialized;
    private static volatile boolean listenOnVisibility;

    protected Crawler(@NonNull URL root, boolean checkTimeStamps, boolean detectDeletedFiles, boolean supportsAllFiles, @NonNull CancelRequest cancelRequest) throws IOException {
        this.root = root;
        this.checkTimeStamps = checkTimeStamps;
        this.timeStamps = TimeStamps.forRoot(root, detectDeletedFiles);
        this.supportsAllFiles = supportsAllFiles;
        this.cancelRequest = cancelRequest;
    }

    public static boolean listenOnVisibility() {
        return listenOnVisibility;
    }

    @NonNull
    public final Collection<IndexableImpl> getResources() throws IOException {
        this.init();
        return this.resources;
    }

    @CheckForNull
    public final Collection<IndexableImpl> getAllResources() throws IOException {
        this.init();
        return this.checkTimeStamps || !this.supportsAllFiles ? this.allResources : this.resources;
    }

    @NonNull
    public final Collection<IndexableImpl> getDeletedResources() throws IOException {
        this.init();
        return this.deleted;
    }

    public final void storeTimestamps() throws IOException {
        this.init();
        this.timeStamps.store();
    }

    public final boolean hasChanged() throws IOException {
        this.init();
        return this.changed;
    }

    public final boolean isFinished() throws IOException {
        this.init();
        return this.finished;
    }

    protected final boolean isUpToDate(@NonNull FileObject f, @NullAllowed String relativePath) {
        boolean upToDate = this.timeStamps.checkAndStoreTimestamp(f, relativePath);
        return this.checkTimeStamps ? upToDate : false;
    }

    protected final boolean isCancelled() {
        return this.cancelRequest.isRaised();
    }

    static void setListenOnVisibility(boolean value) {
        listenOnVisibility = value;
    }

    protected abstract boolean collectResources(@NonNull Collection<IndexableImpl> var1, @NonNull Collection<IndexableImpl> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        if (!this.initialized) {
            try {
                LinkedHashSet<IndexableImpl> _resources = new LinkedHashSet<IndexableImpl>();
                NullCollection<IndexableImpl> _allResources = this.checkTimeStamps && this.supportsAllFiles ? new LinkedHashSet() : new NullCollection();
                this.finished = this.collectResources(_resources, _allResources);
                this.resources = Collections.unmodifiableCollection(_resources);
                this.allResources = this.checkTimeStamps && this.supportsAllFiles ? Collections.unmodifiableCollection(_allResources) : null;
                this.changed = !_resources.isEmpty();
                Set<String> unseen = this.timeStamps.getUnseenFiles();
                if (unseen != null) {
                    this.deleted = new ArrayList<IndexableImpl>(unseen.size());
                    for (String u : unseen) {
                        this.deleted.add(new DeletedIndexable(this.root, u));
                    }
                    this.deleted = Collections.unmodifiableCollection(this.deleted);
                } else {
                    this.deleted = Collections.emptySet();
                }
                this.changed |= !this.deleted.isEmpty();
            }
            finally {
                this.initialized = true;
            }
        }
    }

    private static class NullCollection<T>
    implements Collection<T> {
        private boolean changed;

        private NullCollection() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return !this.changed;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            this.changed = true;
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.changed = true;
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

