/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.ui.WatchPanel;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ColumnModels {
    public static ColumnModel createDefaultBreakpointsColumn() {
        return new AbstractColumn("DefaultBreakpointColumn", "CTL_BreakpointView_Column_Name_Name", "CTL_BreakpointView_Column_Name_Desc", null);
    }

    public static ColumnModel createDefaultCallStackColumn() {
        return new AbstractColumn("DefaultCallStackColumn", "CTL_CallstackView_Column_Name_Name", "CTL_CallstackView_Column_Name_Desc", null, true, null, false, false);
    }

    public static ColumnModel createCallStackLocationColumn() {
        return new AbstractColumn("CallStackFrameLocation", "CTL_CallstackView_Column_Location_Name", "CTL_CallstackView_Column_Location_Desc", String.class, false);
    }

    public static ColumnModel createDefaultLocalsColumn() {
        return new AbstractColumn("DefaultLocalsColumn", "CTL_LocalsView_Column_Name_Name", "CTL_LocalsView_Column_Name_Desc", null, true, null, true, true);
    }

    public static ColumnModel createLocalsToStringColumn() {
        return new AbstractColumn("LocalsToString", "CTL_LocalsView_Column_ToString_Name", "CTL_LocalsView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createLocalsTypeColumn() {
        return new AbstractColumn("LocalsType", "CTL_LocalsView_Column_Type_Name", "CTL_LocalsView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createLocalsValueColumn() {
        return new AbstractColumn("LocalsValue", "CTL_LocalsView_Column_Value_Name", "CTL_LocalsView_Column_Value_Desc", String.class, true);
    }

    public static ColumnModel createDefaultSessionColumn() {
        return new AbstractColumn("DefaultSessionColumn", "CTL_SessionsView_Column_Name_Name", "CTL_SessionsView_Column_Name_Desc", null);
    }

    public static ColumnModel createSessionHostNameColumn() {
        return new AbstractColumn("SessionHostName", "CTL_SessionsView_Column_HostName_Name", "CTL_SessionsView_Column_HostName_Desc", String.class, false);
    }

    public static ColumnModel createSessionStateColumn() {
        return new AbstractColumn("SessionState", "CTL_SessionsView_Column_State_Name", "CTL_SessionsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createSessionLanguageColumn() {
        return new AbstractColumn("SessionLanguage", "CTL_SessionsView_Column_Language_Name", "CTL_SessionsView_Column_Language_Desc", Session.class, true, new LanguagePropertyEditor());
    }

    public static ColumnModel createDefaultThreadColumn() {
        return new AbstractColumn("DefaultThreadColumn", "CTL_ThreadsView_Column_Name_Name", "CTL_ThreadsView_Column_Name_Desc", null);
    }

    public static ColumnModel createThreadStateColumn() {
        return new AbstractColumn("ThreadState", "CTL_ThreadsView_Column_State_Name", "CTL_ThreadsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createThreadSuspendedColumn() {
        return new AbstractColumn("ThreadSuspended", "CTL_ThreadsView_Column_Suspended_Name", "CTL_ThreadsView_Column_Suspended_Desc", Boolean.TYPE, false);
    }

    public static ColumnModel createDefaultWatchesColumn() {
        return new AbstractColumn("DefaultWatchesColumn", "CTL_WatchesView_Column_Name_Name", "CTL_WatchesView_Column_Name_Desc", null, true, null, true, true);
    }

    public static ColumnModel createWatchToStringColumn() {
        return new AbstractColumn("WatchToString", "CTL_WatchesView_Column_ToString_Name", "CTL_WatchesView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createWatchTypeColumn() {
        return new AbstractColumn("WatchType", "CTL_WatchesView_Column_Type_Name", "CTL_WatchesView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createWatchValueColumn() {
        return new AbstractColumn("WatchValue", "CTL_WatchesView_Column_Value_Name", "CTL_WatchesView_Column_Value_Desc", String.class, true);
    }

    static class WatchesTableCellEditor
    implements TableCellEditor,
    FocusListener {
        private JEditorPane editorPane;
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private Object value;
        private Node node;

        WatchesTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
            int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
            String mimeType = file != null ? file.getMIMEType() : "text/plain";
            this.editorPane = new WatchesEditorPane(mimeType, "");
            if (file != null) {
                line = WatchPanel.adjustLine(file, line);
                DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)this.editorPane);
            }
            this.editorPane.addFocusListener(this);
            KeyStroke enterKs = KeyStroke.getKeyStroke(10, 0);
            KeyStroke escKs = KeyStroke.getKeyStroke(27, 0);
            InputMap im = this.editorPane.getInputMap();
            im.put(enterKs, "none");
            im.put(escKs, "none");
            this.setupUI(this.editorPane);
            try {
                Field nodeField = value.getClass().getDeclaredField("node");
                nodeField.setAccessible(true);
                this.node = (Node)nodeField.get(value);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            if (this.node != null) {
                this.editorPane.setText(this.node.getDisplayName());
            }
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setBackground(table.getBackground());
            scrollPane.setViewportView(this.editorPane);
            return scrollPane;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorPane.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent e) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                ArrayList<CellEditorListener> list2 = new ArrayList<CellEditorListener>(this.listeners);
                for (CellEditorListener listener : list2) {
                    listener.editingCanceled(new ChangeEvent(this));
                }
            }
        }

        private void setupUI(JEditorPane editorPane) {
            EditorUI eui = Utilities.getEditorUI((JTextComponent)editorPane);
            if (eui == null) {
                return;
            }
            editorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
            try {
                Field textLimitLineField = EditorUI.class.getDeclaredField("textLimitLineVisible");
                textLimitLineField.setAccessible(true);
                textLimitLineField.set(eui, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            editorPane.repaint();
        }

        class WatchesEditorPane
        extends JEditorPane {
            KeyStroke enter;

            WatchesEditorPane(String type, String text) {
                super(type, text);
                this.enter = KeyStroke.getKeyStroke(10, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (this.enter.equals(ks)) {
                    int id = e.getID();
                    block8: for (KeyListener keyListener : this.getKeyListeners()) {
                        switch (id) {
                            case 400: {
                                keyListener.keyTyped(e);
                                continue block8;
                            }
                            case 401: {
                                keyListener.keyPressed(e);
                                continue block8;
                            }
                            case 402: {
                                keyListener.keyReleased(e);
                            }
                        }
                    }
                    if (!e.isConsumed() && id == 401) {
                        List list = WatchesTableCellEditor.this.listeners;
                        synchronized (list) {
                            ArrayList list2 = new ArrayList(WatchesTableCellEditor.this.listeners);
                            for (CellEditorListener listener : list2) {
                                listener.editingStopped(new ChangeEvent(this));
                            }
                        }
                    }
                    e.consume();
                } else {
                    super.processKeyEvent(e);
                }
            }
        }
    }

    private static class LanguagePropertyEditor
    extends PropertyEditorSupport {
        private LanguagePropertyEditor() {
        }

        @Override
        public void setValue(Object value) {
            if (value != null && !(value instanceof Session)) {
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("Value " + value + " is not an instance of Session!"));
            }
            super.setValue(new WeakReference<Object>(value));
        }

        private Session getSession() {
            Reference sRef = (Reference)this.getValue();
            Session s = sRef != null ? (Session)sRef.get() : null;
            return s;
        }

        @Override
        public String[] getTags() {
            Session s = this.getSession();
            if (s == null) {
                return new String[0];
            }
            return s.getSupportedLanguages();
        }

        @Override
        public String getAsText() {
            Session s = this.getSession();
            if (s == null) {
                return "null";
            }
            return s.getCurrentLanguage();
        }

        @Override
        public void setAsText(String text) {
            Session s = this.getSession();
            if (s != null) {
                s.setCurrentLanguage(text);
            }
        }
    }

    public static class AbstractColumn
    extends ColumnModel {
        private String id;
        private String displayName;
        private String shortDescription;
        private Class type;
        private boolean defaultVisible;
        private PropertyEditor propertyEditor;
        private boolean useTableCellEditor;
        private boolean sortable;
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public AbstractColumn(String id, String displayName, String shortDescription, Class type) {
            this(id, displayName, shortDescription, type, true);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible) {
            this(id, displayName, shortDescription, type, defaultVisible, null);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible, PropertyEditor propertyEditor) {
            this(id, displayName, shortDescription, type, defaultVisible, propertyEditor, false, true);
        }

        public AbstractColumn(String id, String displayName, String shortDescription, Class type, boolean defaultVisible, PropertyEditor propertyEditor, boolean useTableCellEditor, boolean sortable) {
            this.id = id;
            this.displayName = displayName;
            this.shortDescription = shortDescription;
            this.type = type;
            this.defaultVisible = defaultVisible;
            this.propertyEditor = propertyEditor;
            this.useTableCellEditor = useTableCellEditor;
            this.sortable = sortable;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return NbBundle.getBundle(ColumnModels.class).getString(this.displayName);
        }

        public String getShortDescription() {
            return NbBundle.getBundle(ColumnModels.class).getString(this.shortDescription);
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean visible) {
            this.properties.setBoolean(this.getID() + ".visible", visible);
        }

        public void setSorted(boolean sorted) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sorted", sorted);
            }
        }

        public void setSortedDescending(boolean sortedDescending) {
            if (this.sortable) {
                this.properties.setBoolean(this.getID() + ".sortedDescending", sortedDescending);
            }
        }

        public int getCurrentOrderNumber() {
            int cn = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (cn >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++cn;
            }
            return cn;
        }

        public void setCurrentOrderNumber(int newOrderNumber) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", newOrderNumber);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int newColumnWidth) {
            this.properties.setInt(this.getID() + ".columnWidth", newColumnWidth);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean isSorted() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sorted", false);
            }
            return false;
        }

        public boolean isSortedDescending() {
            if (this.sortable) {
                return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
            }
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        public TableCellEditor getTableCellEditor() {
            return this.useTableCellEditor ? new WatchesTableCellEditor() : null;
        }
    }
}

