/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phpdoc.PhpDocumentorProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class BrowseFolderPanel
extends JPanel {
    private static final long serialVersionUID = 1743213547571L;
    private final String info;
    private final PhpModule phpModule;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JButton browseTargetFolderButton;
    private JLabel targetFolderLabel;
    private JTextField targetFolderTextField;

    private BrowseFolderPanel(String info, PhpModule phpModule) {
        assert (info != null);
        assert (phpModule != null);
        this.info = info;
        this.phpModule = phpModule;
        this.initComponents();
        this.targetFolderTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                BrowseFolderPanel.this.validateFolder();
            }
        });
    }

    public static String open(PhpModule phpModule) {
        String info = NbBundle.getMessage(BrowseFolderPanel.class, (String)"LBL_SelectDocFolder", (Object)phpModule.getDisplayName());
        BrowseFolderPanel panel = new BrowseFolderPanel(info, phpModule);
        panel.dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(BrowseFolderPanel.class, (String)"LBL_SelectDir"), true, 2, DialogDescriptor.OK_OPTION, null);
        panel.notificationLineSupport = panel.dialogDescriptor.createNotificationLineSupport();
        panel.notificationLineSupport.setInformationMessage(info);
        panel.dialogDescriptor.setValid(false);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)panel.dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            return panel.getDocFolder();
        }
        return null;
    }

    private String getDocFolder() {
        return this.targetFolderTextField.getText().trim();
    }

    void validateFolder() {
        assert (this.notificationLineSupport != null);
        String docFolder = this.getDocFolder();
        String error = FileUtils.validateDirectory((String)docFolder);
        if (error != null) {
            this.notificationLineSupport.setErrorMessage(error);
            this.dialogDescriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.targetFolderLabel = new JLabel();
        this.targetFolderTextField = new JTextField();
        this.browseTargetFolderButton = new JButton();
        this.targetFolderLabel.setLabelFor(this.targetFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.targetFolderLabel, (String)NbBundle.getMessage(BrowseFolderPanel.class, (String)"BrowseFolderPanel.targetFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseTargetFolderButton, (String)NbBundle.getMessage(BrowseFolderPanel.class, (String)"BrowseFolderPanel.browseTargetFolderButton.text"));
        this.browseTargetFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowseFolderPanel.this.browseTargetFolderButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.targetFolderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetFolderTextField, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseTargetFolderButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetFolderLabel).addComponent(this.targetFolderTextField, -2, -1, -2).addComponent(this.browseTargetFolderButton))));
    }

    private void browseTargetFolderButtonActionPerformed(ActionEvent evt) {
        File phpDocTarget = new FileChooserBuilder(PhpDocumentorProvider.class.getName() + ".phpdoc.dir" + this.phpModule.getName()).setTitle(this.info).setDirectoriesOnly(true).setFileHiding(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (phpDocTarget != null) {
            phpDocTarget = FileUtil.normalizeFile((File)phpDocTarget);
            this.targetFolderTextField.setText(phpDocTarget.getAbsolutePath());
        }
    }
}

