/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.action.CallEjbGenerator;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.CallEjbPanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.EJBListViewChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.EjbChildren;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CallEjbDialog {
    public boolean open(final FileObject referencingFO, final String referencingClassName, String title) throws IOException {
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)referencingFO);
        Project[] allProjects = Utils.getCallableEjbProjects(enterpriseProject);
        LinkedList<1> ejbProjectNodes = new LinkedList<1>();
        for (int i = 0; i < allProjects.length; ++i) {
            EjbsNode projectView = new EjbsNode(allProjects[i]);
            ejbProjectNodes.add(new FilterNode((Node)projectView, (Children)new EjbChildren((Node)projectView)){

                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            });
        }
        Children.Array children = new Children.Array();
        children.add(ejbProjectNodes.toArray(new Node[ejbProjectNodes.size()]));
        AbstractNode root = new AbstractNode((Children)children);
        root.setDisplayName(NbBundle.getMessage(CallEjbDialog.class, (String)"LBL_EJBModules"));
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
        boolean isJavaEE5orHigher = Util.isJavaEE5orHigher((Project)enterpriseProject);
        final CallEjbPanel panel = new CallEjbPanel(referencingFO, (Node)root, isJavaEE5orHigher ? null : erc.getServiceLocatorName(), referencingClassName);
        if (isJavaEE5orHigher) {
            panel.disableServiceLocator();
        }
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, title, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CallEjbPanel.class), null);
        NotificationLineSupport statusLine = dialogDescriptor.createNotificationLineSupport();
        panel.setNotificationLine(statusLine);
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("CallEjbPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        panel.validateReferences();
        Object button = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (button != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        Node ejbNode = panel.getEjb();
        final boolean throwExceptions = !panel.convertToRuntime();
        EjbReference ref = (EjbReference)ejbNode.getLookup().lookup(EjbReference.class);
        String referenceNameFromPanel = panel.getReferenceName();
        if (referenceNameFromPanel != null && referenceNameFromPanel.trim().equals("")) {
            referenceNameFromPanel = null;
        }
        final FileObject fileObject = (FileObject)ejbNode.getLookup().lookup(FileObject.class);
        final Project nodeProject = FileOwnerQuery.getOwner((FileObject)fileObject);
        boolean isDefaultRefName = panel.isDefaultRefName();
        final String referencedClassName = _RetoucheUtil.getJavaClassFromNode(ejbNode).getQualifiedName();
        final CallEjbGenerator generator = CallEjbGenerator.create(ref, referenceNameFromPanel, isDefaultRefName);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    final ElementHandle<? extends Element> elementHandle = generator.addReference(referencingFO, referencingClassName, fileObject, referencedClassName, panel.getServiceLocator(), panel.getSelectedInterface(), throwExceptions, nodeProject);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ElementOpen.open((FileObject)referencingFO, (ElementHandle)elementHandle);
                        }
                    });
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
        return true;
    }

    private class EjbsNode
    extends AbstractNode {
        public EjbsNode(Project project) {
            super((Children)new EJBListViewChildren(project), Lookups.singleton((Object)project));
            J2eeModuleProvider module = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (module != null && module.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
                this.setIconBaseWithExtension("org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif");
            } else {
                this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbjarproject/ui/resources/ejbjarProjectIcon.gif");
            }
            super.setName(ProjectUtils.getInformation((Project)project).getDisplayName());
        }
    }
}

