/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.CallEjbDialog;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SendEmailCodeGenerator;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CallEjbCodeGenerator
implements CodeGenerator {
    private FileObject srcFile;
    private TypeElement beanClass;

    static CallEjbCodeGenerator createCallEjbAction(JTextComponent component, CompilationController cc, Element el) throws IOException {
        if (el.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)el;
        if (!CallEjbCodeGenerator.isEnable(cc.getFileObject(), typeElement)) {
            return null;
        }
        return new CallEjbCodeGenerator(cc.getFileObject(), typeElement);
    }

    public CallEjbCodeGenerator(FileObject srcFile, TypeElement beanClass) {
        this.srcFile = srcFile;
        this.beanClass = beanClass;
    }

    public void invoke() {
        try {
            CallEjbDialog callEjbDialog = new CallEjbDialog();
            callEjbDialog.open(this.srcFile, this.beanClass.getQualifiedName().toString(), NbBundle.getMessage(CallEjbCodeGenerator.class, (String)"LBL_CallEjbActionTitle"));
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CallEjbCodeGenerator.class, (String)"LBL_CallEjbAction");
    }

    private static boolean isEnable(FileObject srcFile, TypeElement typeElement) {
        Project project = FileOwnerQuery.getOwner((FileObject)srcFile);
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            if (project.getLookup().lookup(EnterpriseReferenceContainer.class) == null) {
                return false;
            }
            String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
            if (serverInstanceId == null) {
                return true;
            }
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceId);
            if (platform == null) {
                return true;
            }
            if (!platform.getSupportedTypes().contains(J2eeModule.Type.EJB)) {
                return false;
            }
        } else {
            return false;
        }
        return ElementKind.INTERFACE != typeElement.getKind();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<CallEjbCodeGenerator> ret = new ArrayList<CallEjbCodeGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? SendEmailCodeGenerator.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                CallEjbCodeGenerator gen;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element elem = controller.getTrees().getElement(path);
                if (elem != null && (gen = CallEjbCodeGenerator.createCallEjbAction(component, controller, elem)) != null) {
                    ret.add(gen);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return ret;
        }
    }
}

