/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class _RetoucheUtil {
    private _RetoucheUtil() {
    }

    public static String getMainClassName(FileObject classFO) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)classFO);
        final String[] result = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                if (typeElement != null) {
                    result[0] = typeElement.getQualifiedName().toString();
                }
            }
        }, true);
        return result[0];
    }

    public static boolean containsFeature(TypeElement javaClass, Element searchedElement) {
        for (Element element : javaClass.getEnclosedElements()) {
            if (!((Object)searchedElement.getSimpleName()).equals(element.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static ElementHandle<TypeElement> getElementHandle(ElementHandle elementHandle) {
        if (elementHandle != null && ElementKind.CLASS == elementHandle.getKind()) {
            return elementHandle;
        }
        return null;
    }

    public static ElementHandle<TypeElement> getJavaClassFromNode(Node node) throws IOException {
        ElementHandle<TypeElement> elementHandle = _RetoucheUtil.getElementHandle((ElementHandle)node.getLookup().lookup(ElementHandle.class));
        if (elementHandle != null) {
            return elementHandle;
        }
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return null;
        }
        final ArrayList result = new ArrayList();
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    if (typeElement != null) {
                        result.add(ElementHandle.create((Element)typeElement));
                    }
                }
            }, true);
        }
        catch (DataObjectNotFoundException donfe) {
            // empty catch block
        }
        if (result.size() > 0) {
            return (ElementHandle)result.get(0);
        }
        return null;
    }

    public static ExecutableElement getMethodFromNode(Node node) {
        return null;
    }

    public static ElementHandle<VariableElement> generateAnnotatedField(FileObject fileObject, final String className, final String annotationType, final String name, final String fieldType, final Map<String, String> attributes, final boolean isStatic) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                TypeElement returnTypeElement = workingCopy.getElements().getTypeElement(fieldType);
                assert (returnTypeElement != null) : "TypeElement not found for " + fieldType;
                HashSet<Modifier> modifiers = new HashSet<Modifier>();
                modifiers.add(Modifier.PRIVATE);
                if (isStatic) {
                    modifiers.add(Modifier.STATIC);
                }
                ArrayList<ExpressionTree> attributesList = new ArrayList<ExpressionTree>();
                if (attributes != null) {
                    for (Map.Entry entry : attributes.entrySet()) {
                        ExpressionTree attributeTree = generationUtils.createAnnotationArgument((String)entry.getKey(), entry.getValue());
                        attributesList.add(attributeTree);
                    }
                }
                AnnotationTree annotationTree = generationUtils.createAnnotation(annotationType, attributesList);
                ModifiersTree modifiersTree = treeMaker.addModifiersAnnotation(treeMaker.Modifiers(modifiers), annotationTree);
                VariableTree variableTree = treeMaker.Variable(modifiersTree, (CharSequence)name, (Tree)treeMaker.QualIdent((Element)returnTypeElement), null);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = treeMaker.insertClassMember(classTree, 0, (Tree)variableTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return _RetoucheUtil.getFieldHandle(javaSource, className, fieldType, name);
    }

    public static boolean isInterface(FileObject fileObject, final ElementHandle<TypeElement> elementHandle) throws IOException {
        final boolean[] isInterface = new boolean[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null || elementHandle == null) {
            return false;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)controller);
                isInterface[0] = ElementKind.INTERFACE == typeElement.getKind();
            }
        }, true);
        return isInterface[0];
    }

    public static String uniqueMemberName(FileObject fileObject, final String className, final String memberName, final String defaultValue) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] result = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                String newName = _RetoucheUtil.convertToJavaIdentifier(memberName, defaultValue);
                ArrayList<String> existingMethodNames = new ArrayList<String>();
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                for (Element element : typeElement.getEnclosedElements()) {
                    existingMethodNames.add(element.getSimpleName().toString());
                }
                int uniquefier = 1;
                while (existingMethodNames.contains(newName)) {
                    newName = memberName + uniquefier++;
                }
                result[0] = newName;
            }
        }, true);
        return result[0];
    }

    private static String convertToJavaIdentifier(String name, String defaultValue) {
        Parameters.notWhitespace((CharSequence)"name", (CharSequence)name);
        Parameters.notWhitespace((CharSequence)"defaultValue", (CharSequence)defaultValue);
        String str = name;
        while (str.length() > 0 && !Character.isJavaIdentifierStart(str.charAt(0))) {
            str = str.substring(1);
        }
        StringBuilder result = new StringBuilder();
        if (str.length() > 0) {
            char firstChar = str.charAt(0);
            firstChar = Character.toLowerCase(firstChar);
            result.append(firstChar);
            for (int i = 1; i < str.length(); ++i) {
                char character = str.charAt(i);
                if (!Character.isJavaIdentifierPart(character)) continue;
                result.append(character);
            }
        } else {
            result.append(defaultValue);
        }
        return result.toString();
    }

    public static FileObject resolveFileObjectForClass(FileObject referenceFileObject, final String className) throws IOException {
        final FileObject[] result = new FileObject[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)referenceFileObject);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) {
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                if (typeElement != null) {
                    result[0] = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)controller.getClasspathInfo());
                }
            }
        }, true);
        return result[0];
    }

    public static String getTypeName(CompilationController controller, TypeMirror typeMirror) {
        TypeKind typeKind = typeMirror.getKind();
        switch (typeKind) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
            case DECLARED: {
                Element element = controller.getTypes().asElement(typeMirror);
                return ((TypeElement)element).getQualifiedName().toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                Element componentTypeElement = controller.getTypes().asElement(arrayType.getComponentType());
                return ((TypeElement)componentTypeElement).getQualifiedName().toString() + "[]";
            }
        }
        return null;
    }

    public static ElementHandle<ExecutableElement> getMethodHandle(JavaSource javaSource, final MethodModel methodModel, final String className) throws IOException {
        final ElementHandle[] result = new ElementHandle[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    if (!MethodModelSupport.isSameMethod((CompilationController)controller, (ExecutableElement)method, (MethodModel)methodModel)) continue;
                    result[0] = ElementHandle.create((Element)method);
                    return;
                }
            }
        }, true);
        return result[0];
    }

    public static ElementHandle<VariableElement> getFieldHandle(JavaSource javaSource, final String className, final String fieldType, final String fieldName) throws IOException {
        final ElementHandle[] result = new ElementHandle[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                for (VariableElement variable : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                    if (!variable.getSimpleName().contentEquals(fieldName) || !fieldType.equals(_RetoucheUtil.getTypeName(controller, variable.asType()))) continue;
                    result[0] = ElementHandle.create((Element)variable);
                    return;
                }
            }
        }, true);
        return result[0];
    }

    public static Set<MethodModel> getMethods(FileObject fileObject, final String className) {
        final HashSet<MethodModel> result = new HashSet<MethodModel>();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = controller.getElements().getTypeElement(className);
                    if (typeElement != null) {
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            MethodModel mm = MethodModelSupport.createMethodModel((CompilationController)controller, (ExecutableElement)executableElement);
                            if (mm == null) continue;
                            result.add(mm);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result;
    }
}

