/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.weaving;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.toplink.essentials.exceptions.StaticWeaveException;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.weaving.StaticWeaveProcessor;

public class StaticWeave {
    private String[] argv;
    private String source;
    private String persistenceinfopath;
    private String target;
    private int loglevel = 8;
    private Writer logWriter;
    private PrintStream vout = System.out;
    private String[] classpaths;

    public static void main(String[] argv) {
        StaticWeave staticweaver = new StaticWeave(argv);
        try {
            staticweaver.processCommandLine();
            staticweaver.start();
        }
        catch (Exception e) {
            throw StaticWeaveException.exceptionPerformWeaving(e);
        }
    }

    public StaticWeave(String[] argv) {
        this.argv = argv;
    }

    public void start() throws Exception {
        StaticWeaveProcessor staticWeaverProcessor = new StaticWeaveProcessor(this.source, this.target);
        if (this.persistenceinfopath != null) {
            staticWeaverProcessor.setPersistenceInfo(this.persistenceinfopath);
        }
        if (this.classpaths != null) {
            staticWeaverProcessor.setClassLoader(this.getClassLoader());
        }
        if (this.logWriter != null) {
            staticWeaverProcessor.setLog(this.logWriter);
        }
        staticWeaverProcessor.setLogLevel(this.loglevel);
        staticWeaverProcessor.performWeaving();
    }

    void processCommandLine() throws Exception {
        if (this.argv.length < 2 || this.argv.length > 10) {
            this.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].equalsIgnoreCase("-classpath")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.classpaths = this.argv[i + 1].split(File.pathSeparator);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-persistenceinfo")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.persistenceinfopath = this.argv[i + 1];
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-log")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.logWriter = new FileWriter(this.argv[i + 1]);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-loglevel")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                if (this.argv[i + 1].equalsIgnoreCase("OFF") || this.argv[i + 1].equalsIgnoreCase("SEVERE") || this.argv[i + 1].equalsIgnoreCase("WARNING") || this.argv[i + 1].equalsIgnoreCase("INFO") || this.argv[i + 1].equalsIgnoreCase("CONFIG") || this.argv[i + 1].equalsIgnoreCase("FINE") || this.argv[i + 1].equalsIgnoreCase("FINER") || this.argv[i + 1].equalsIgnoreCase("FINEST") || this.argv[i + 1].equalsIgnoreCase("ALL")) {
                    this.loglevel = AbstractSessionLog.translateStringToLoggingLevel(this.argv[i + 1].toUpperCase());
                } else {
                    this.printUsage();
                    System.exit(1);
                }
                ++i;
                continue;
            }
            if (this.source != null) {
                this.printUsage();
                System.exit(1);
            }
            if (this.target != null) {
                this.printUsage();
                System.exit(1);
            }
            this.source = this.argv[i];
            if (i + 1 >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            if (++i >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            this.target = this.argv[i];
            ++i;
        }
        if (this.source == null) {
            this.printUsage();
            throw StaticWeaveException.missingSource();
        }
        if (this.target == null) {
            this.printUsage();
            throw StaticWeaveException.missingTarget();
        }
    }

    private void printUsage() {
        PrintStream o = this.vout;
        o.println(ToStringLocalization.buildMessage("staticweave_commandline_help_message", new Object[]{null}));
    }

    private ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classpaths != null) {
            URL[] urls = new URL[this.classpaths.length];
            for (int i = 0; i < this.classpaths.length; ++i) {
                urls[i] = new File(this.classpaths[i]).toURL();
            }
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }
}

