/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.progress;

import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.openide.util.Parameters;

public class MultiProgressObjectWrapper
implements ProgressObject,
ProgressListener {
    private final ProgressEventSupport pes = new ProgressEventSupport(this);
    private final ProgressObject[] progressObjects;
    private String message = "";
    private StateType state = StateType.RUNNING;

    public MultiProgressObjectWrapper(ProgressObject[] objects) {
        Parameters.notNull((CharSequence)"progObjs", (Object)this.state);
        if (objects.length == 0) {
            throw new IllegalArgumentException("At least one progress object must be passed.");
        }
        this.progressObjects = new ProgressObject[objects.length];
        System.arraycopy(objects, 0, this.progressObjects, 0, objects.length);
        for (int i = 0; i < objects.length; ++i) {
            ProgressObject po = objects[i];
            po.addProgressListener((ProgressListener)this);
        }
        this.updateState(null);
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        DeploymentStatus ds = this.progressObjects[0].getDeploymentStatus();
        return new Status(ds.getAction(), ds.getCommand(), this.message, this.state);
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        ArrayList<TargetModuleID> returnVal = new ArrayList<TargetModuleID>();
        for (int i = 0; i < this.progressObjects.length; ++i) {
            ProgressObject po = this.progressObjects[i];
            if (!po.getDeploymentStatus().isCompleted()) continue;
            returnVal.addAll(Arrays.asList(po.getResultTargetModuleIDs()));
        }
        return returnVal.toArray(new TargetModuleID[returnVal.size()]);
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported in Tomcat deployment");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported in Tomcat deployment");
    }

    public void addProgressListener(ProgressListener l) {
        this.pes.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.pes.removeProgressListener(l);
    }

    public synchronized void handleProgressEvent(ProgressEvent progressEvent) {
        this.updateState(progressEvent.getDeploymentStatus().getMessage());
        this.pes.fireHandleProgressEvent(progressEvent.getTargetModuleID(), progressEvent.getDeploymentStatus());
    }

    private synchronized void updateState(String receivedMessage) {
        if (this.state == StateType.COMPLETED || this.state == StateType.FAILED) {
            return;
        }
        boolean completed = true;
        boolean failed = false;
        for (ProgressObject progress : this.progressObjects) {
            DeploymentStatus status = progress.getDeploymentStatus();
            if (status == null || !status.isCompleted() && !status.isFailed()) {
                completed = false;
                break;
            }
            if (!status.isFailed()) continue;
            failed = true;
        }
        if (completed) {
            this.state = failed ? StateType.FAILED : StateType.COMPLETED;
            this.message = receivedMessage == null ? "" : receivedMessage;
        }
    }
}

