/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public abstract class SourceAbstractDataLoader
extends UniFileLoader {
    static final long serialVersionUID = 6801389470714975682L;

    protected SourceAbstractDataLoader(String representationClassName) {
        super(representationClassName);
    }

    protected abstract String getMimeType();

    protected final void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(this.getMimeType());
    }

    protected String actionsContext() {
        return "Loaders/text/x-cnd+sourcefile/Actions/";
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new CndFormat(obj, primaryFile);
    }

    private static EditorKit createEditorKit(String mimeType) {
        EditorKit kit = JEditorPane.createEditorKitForContentType(mimeType);
        if (kit == null) {
            kit = new DefaultEditorKit();
        }
        return kit;
    }

    private static boolean setTemplate(FileObject fo, boolean newTempl) throws IOException {
        boolean oldTempl = false;
        Object o = fo.getAttribute("template");
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            oldTempl = true;
        }
        if (oldTempl == newTempl) {
            return false;
        }
        fo.setAttribute("template", (Object)(newTempl ? Boolean.TRUE : null));
        return true;
    }

    private static class CndFormat
    extends FileEntry.Format {
        public CndFormat(MultiDataObject obj, FileObject primaryFile) {
            super(obj, primaryFile);
        }

        protected Format createFormat(FileObject target, String name, String ext) {
            HashMap<String, String> map = new HashMap<String, String>();
            String packageName = target.getPath().replace('/', '_');
            if (!packageName.isEmpty()) {
                packageName = packageName + "_";
            }
            map.put("PACKAGE_AND_NAME", packageName + name);
            map.put("NAME", name);
            map.put("EXTENSION", ext);
            String fullName = name + "_" + ext;
            StringBuilder guardName = new StringBuilder();
            for (int i = 0; i < fullName.length(); ++i) {
                char c = fullName.charAt(i);
                guardName.append(Character.isJavaIdentifierPart(c) ? (char)Character.toUpperCase(c) : (char)'_');
            }
            map.put("GUARD_NAME", guardName.toString());
            int crop = name.lastIndexOf(95);
            if (crop != -1) {
                name = name.substring(0, crop);
            }
            map.put("CROPPEDNAME", name);
            map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            map.put("QUOTES", "\"");
            for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Map attrs = provider.attributesFor((DataObject)this.getDataObject(), DataFolder.findFolder((FileObject)target), name);
                if (attrs == null) continue;
                for (Map.Entry entry : attrs.entrySet()) {
                    map.put(((String)entry.getKey()).toUpperCase(), (String)entry.getValue());
                }
            }
            MapFormat format = new MapFormat(map);
            format.setLeftBrace("%<%");
            format.setRightBrace("%>%");
            return format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext;
            if (MIMEExtensions.isCustomizableExtensions((String)this.getFile().getMIMEType())) {
                ext = FileUtil.getExtension((String)name);
                if (ext.length() != 0) {
                    name = name.substring(0, name.length() - ext.length() - 1);
                }
            } else {
                ext = this.getFile().getExt();
            }
            FileObject fo = f.createData(name, ext);
            Format frm = this.createFormat(f, name, ext);
            EditorKit kit = SourceAbstractDataLoader.createEditorKit(this.getFile().getMIMEType());
            Document doc = kit.createDefaultDocument();
            String lsType = (String)doc.getProperty("__EndOfLine__");
            if (lsType == null) {
                lsType = "\n";
            }
            if (!CndFileUtils.isLocalFileSystem((FileSystem)fo.getFileSystem())) {
                lsType = "\n";
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.getFile())));
            try {
                FileLock lock = fo.lock();
                try {
                    Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
                    if (!CndFileUtils.isLocalFileSystem((FileSystem)fo.getFileSystem()) && encoding.equals(Charset.defaultCharset())) {
                        encoding = FileEncodingQuery.getEncoding((FileObject)f);
                    }
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock), encoding));
                    try {
                        String current;
                        String line = null;
                        int offset = 0;
                        while ((current = r.readLine()) != null) {
                            if (line != null) {
                                doc.insertString(offset, "\n", null);
                                ++offset;
                            }
                            line = frm.format(current);
                            doc.insertString(offset, line, null);
                            offset += line.length();
                        }
                        doc.insertString(doc.getLength(), "\n", null);
                        ++offset;
                        Reformat reformat = Reformat.get((Document)doc);
                        reformat.lock();
                        try {
                            reformat.reformat(0, doc.getLength());
                        }
                        finally {
                            reformat.unlock();
                        }
                        for (String s : doc.getText(0, doc.getLength()).split("\n")) {
                            w.write(s);
                            w.write(lsType);
                        }
                        w.write(lsType);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        w.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            finally {
                r.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            SourceAbstractDataLoader.setTemplate(fo, false);
            return fo;
        }
    }
}

