/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SvnFileNode {
    private final File file;
    private String relativePath;
    private String copy;
    private boolean copyScanned;
    private Boolean fileFlag;
    private String mimeType;

    public SvnFileNode(File file) {
        this.file = FileUtil.normalizeFile((File)file);
    }

    public String getName() {
        return this.file.getName();
    }

    public FileInformation getInformation() {
        return Subversion.getInstance().getStatusCache().getStatus(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof SvnFileNode && this.file.equals(((SvnFileNode)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)this.file);
    }

    public Object[] getLookupObjects() {
        ArrayList<File> list = new ArrayList<File>(2);
        list.add(this.file);
        FileObject fo = this.getFileObject();
        if (fo != null) {
            list.add((File)fo);
        }
        return list.toArray(new Object[list.size()]);
    }

    public String getLocation() {
        if (this.relativePath == null) {
            try {
                assert (!EventQueue.isDispatchThread());
                this.relativePath = SvnModuleConfig.getDefault().isRepositoryPathPrefixed() ? SvnUtils.getRepositoryUrl(this.getFile()).toString() : SvnUtils.getRelativePath(this.getFile());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            if (this.relativePath == null) {
                this.relativePath = NbBundle.getMessage(SvnFileNode.class, (String)"SvnFileNode.relativePath.unknown");
            }
        }
        return this.relativePath;
    }

    public String getCopy() {
        if (!this.copyScanned) {
            assert (!EventQueue.isDispatchThread());
            this.copy = SvnUtils.getCopy(this.getFile());
            this.copyScanned = true;
        }
        return this.copy;
    }

    public boolean isFile() {
        if (this.fileFlag == null) {
            this.fileFlag = this.file.isFile();
        }
        return this.fileFlag;
    }

    public String getMimeType() {
        if (this.isFile() && this.mimeType == null) {
            this.mimeType = SvnUtils.getMimeType(this.file);
        }
        return this.mimeType;
    }

    public void initializeProperties() {
        this.getLocation();
        this.getCopy();
        this.isFile();
        this.getMimeType();
    }
}

