/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.spi.actions.ContextAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class RemoveConfigurationAction
extends ContextAction<Node> {
    private RemoveConfigurationAction() {
        super(Node.class);
        this.putValue("Name", NbBundle.getMessage(RemoveConfigurationAction.class, (String)"ACSN_RemovePanel"));
    }

    public static Action getStaticInstance() {
        return new RemoveConfigurationAction();
    }

    protected void performAction(final Node[] activatedNodes) {
        StringBuffer buffer = new StringBuffer();
        for (Node node : activatedNodes) {
            ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
            buffer.append('\n').append(conf.getDisplayName());
        }
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RemoveConfigurationAction.class, (String)"LBL_VCS_ReallyRemove", (Object)buffer), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    for (Node node : activatedNodes) {
                        ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                        J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
                        RemoveConfigurationAction.this.removeProperties(project, conf);
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    private void removeProperties(J2MEProject project, ProjectConfiguration conf) {
        J2MEProjectProperties j2meProperties = new J2MEProjectProperties(project, (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class), project.getConfigurationHelper());
        String[] keys = j2meProperties.keySet().toArray(new String[j2meProperties.size()]);
        String prefix = "configs." + conf.getDisplayName();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith(prefix)) continue;
            j2meProperties.remove(keys[i]);
        }
        List<ProjectConfiguration> col = Arrays.asList(j2meProperties.getConfigurations());
        ArrayList<ProjectConfiguration> list = new ArrayList<ProjectConfiguration>();
        list.addAll(col);
        list.remove(conf);
        if (project.getConfigurationHelper().getActiveConfiguration().equals(conf)) {
            try {
                project.getConfigurationHelper().setActiveConfiguration(project.getConfigurationHelper().getDefaultConfiguration());
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        j2meProperties.setConfigurations(list.toArray(new ProjectConfiguration[list.size()]));
        j2meProperties.store();
    }

    public void actionPerformed(Collection<? extends Node> nodes) {
        Node[] n = nodes.toArray(new Node[nodes.size()]);
        this.performAction(n);
    }
}

