/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class StopManager {
    private static final StopManager DEFAULT = new StopManager();
    private static final Logger LOGGER = Logger.getLogger(StopManager.class.getName());
    private final PropertyChangeListener listener = new StopPropertyChangeListener();
    private final AtomicBoolean isStopping = new AtomicBoolean(false);
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private volatile DatabaseServer server;

    private StopManager() {
    }

    public static StopManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getStopListener() {
        return this.listener;
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    private void disconnectConnections() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        String url = this.server.getURL();
        for (DatabaseConnection dbconn : connections) {
            if (!MySQLOptions.getDriverClass().equals(dbconn.getDriverClass()) || !dbconn.getDatabaseURL().contains(url)) continue;
            ConnectionManager.getDefault().disconnect(dbconn);
        }
    }

    public void stop(final DatabaseServer server) {
        this.server = server;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean stopping = StopManager.this.isStopping.getAndSet(true);
                    if (stopping) {
                        LOGGER.log(Level.FINE, "Server is already stopping");
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StopManager.class, (String)"MSG_StoppingMySQL"));
                    StopManager.this.stopRequested.set(true);
                    server.stop();
                    StopManager.this.disconnectAndWaitForStop();
                }
                catch (DatabaseException dbe) {
                    Utils.displayError(Utils.getMessage("MSG_UnableToStopServer", new Object[0]), (Exception)((Object)dbe));
                }
                finally {
                    StopManager.this.isStopping.set(false);
                }
            }
        });
    }

    private void disconnectAndWaitForStop() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(StopManager.class, (String)"MSG_WaitingForServerToStop"));
                handle.start();
                handle.switchToIndeterminate();
                try {
                    boolean keepTrying;
                    do {
                        if (!StopManager.this.waitForStop()) continue;
                        StopManager.this.stopRequested.set(false);
                        return;
                    } while (keepTrying = StopManager.this.displayServerRunning());
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private boolean displayServerRunning() {
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.CancelButton"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.CancelButtonA11yDesc"));
        JButton keepWaitingButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)keepWaitingButton, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.KeepWaitingButton"));
        keepWaitingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.KeepWaitingButtonA11yDesc"));
        JButton propsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)propsButton, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.PropsButton"));
        propsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.PropsButtonA11yDesc"));
        String message = NbBundle.getMessage(StopManager.class, (String)"MSG_ServerStillRunning");
        final NotifyDescriptor ndesc = new NotifyDescriptor((Object)message, NbBundle.getMessage(StopManager.class, (String)"StopManager.ServerStillRunningTitle"), 1, 3, new Object[]{keepWaitingButton, propsButton, cancelButton}, NotifyDescriptor.CANCEL_OPTION);
        Object ret = Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                return DialogDisplayer.getDefault().notify(ndesc);
            }
        });
        if (cancelButton.equals(ret)) {
            this.stopRequested.set(false);
            return false;
        }
        if (keepWaitingButton.equals(ret)) {
            return true;
        }
        this.displayAdminProperties(this.server);
        return false;
    }

    private void displayAdminProperties(final DatabaseServer server) {
        Mutex.EVENT.postReadRequest(new Runnable(){

            @Override
            public void run() {
                PropertiesDialog dlg = new PropertiesDialog(server);
                dlg.displayDialog(PropertiesDialog.Tab.ADMIN);
            }
        });
    }

    private boolean waitForStop() {
        for (int tries = 0; tries <= 10; ++tries) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.INFO, "Interrupted waiting for server to stop", ie);
                Thread.currentThread().interrupt();
                return true;
            }
            try {
                this.server.reconnect();
                continue;
            }
            catch (DatabaseException dbe) {
                this.server.disconnect();
                this.disconnectConnections();
                return true;
            }
            catch (TimeoutException te) {
                LOGGER.log(Level.INFO, te.getMessage(), te);
                this.server.disconnect();
                this.disconnectConnections();
                return true;
            }
        }
        return false;
    }

    private class StopPropertyChangeListener
    implements PropertyChangeListener {
        private StopPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseServer server = (DatabaseServer)evt.getSource();
            if (("stop-args".equals(evt.getPropertyName()) || "stop-path".equals(evt.getPropertyName())) && StopManager.this.stopRequested.get()) {
                StopManager.this.stop(server);
            }
        }
    }
}

