/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2JavaEEPlatformFactory;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class Hk2JavaEEPlatformImpl
extends J2eePlatformImpl2 {
    private Hk2DeploymentManager dm;
    private final LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
    private final LibraryImplementation[] libraries = new LibraryImplementation[]{this.lib};
    private Hk2JavaEEPlatformFactory pf;
    private FileChangeListener fcl;
    private static final String PERSISTENCE_PROV_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String TOOL_WSCOMPILE = "wscompile";
    private static final String TOOL_JSR109 = "jsr109";
    private static final String TOOL_WSIMPORT = "wsimport";
    private static final String TOOL_WSGEN = "wsgen";
    private static final String TOOL_KEYSTORE = "keystore";
    private static final String TOOL_KEYSTORECLIENT = "keystoreClient";
    private static final String TOOL_TRUSTSTORE = "truststore";
    private static final String TOOL_TRUSTSTORECLIENT = "truststoreClient";
    private static final String TOOL_WSIT = "wsit";
    private static final String TOOL_JAXWSTESTER = "jaxws-tester";
    private static final String TOOL_APPCLIENTRUNTIME = "appClientRuntime";
    private static final String KEYSTORE_LOCATION = "config/keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "config/cacerts.jks";
    private static final String EMBEDDED_EJB_CONTAINER_PATH = "lib/embedded/glassfish-embedded-static-shell.jar";
    private static RequestProcessor libInitThread = new RequestProcessor("init libs -- Hk2JavaEEPlatformImpl");

    public Hk2JavaEEPlatformImpl(Hk2DeploymentManager dm, Hk2JavaEEPlatformFactory pf) {
        this.dm = dm;
        this.pf = pf;
        this.addFcl();
        this.initLibraries();
    }

    private void addFcl() {
        if (null == this.fcl) {
            String path = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("homefolder");
            File f = new File(path, "modules");
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            if (null == fo) {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, "{0} did not exist but should", f.getAbsolutePath());
                return;
            }
            this.fcl = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDataCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileChanged(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDeleted(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                }
            };
            fo.addFileChangeListener(this.fcl);
        }
    }

    public boolean isToolSupported(String toolName) {
        if (PERSISTENCE_PROV_ECLIPSELINK.equals(toolName)) {
            return true;
        }
        if ("org.hibernate.ejb.HibernatePersistence".equals(toolName) || "oracle.toplink.essentials.PersistenceProvider".equals(toolName) || "kodo.persistence.PersistenceProviderImpl".equals(toolName) || "org.apache.openjpa.persistence.PersistenceProviderImpl".equals(toolName)) {
            return true;
        }
        if ("defaultPersistenceProviderJavaEE5".equals(toolName)) {
            return true;
        }
        if ("eclipseLinkPersistenceProviderIsDefault".equals(toolName)) {
            return true;
        }
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        if ("embeddableejb".equals(toolName)) {
            File jar = new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH);
            return jar.exists() && jar.isFile() && jar.canRead();
        }
        File wsLib = null;
        if (gfRootStr != null) {
            wsLib = ServerUtilities.getJarName((String)gfRootStr, (String)"webservices(|-osgi).jar");
        }
        if (wsLib != null && wsLib.exists()) {
            if (TOOL_WSGEN.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIMPORT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIT.equals(toolName)) {
                return true;
            }
            if (TOOL_JAXWSTESTER.equals(toolName)) {
                return true;
            }
            if (TOOL_JSR109.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                return true;
            }
            if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
                return true;
            }
        }
        return false;
    }

    public File[] getToolClasspathEntries(String toolName) {
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        if (null != gfRootStr) {
            String domainDirName;
            if ("embeddableejb".equals(toolName)) {
                return new File[]{new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH)};
            }
            if (TOOL_WSGEN.equals(toolName) || TOOL_WSIMPORT.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.activation.jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            File domainDir = null;
            File gfRoot = new File(gfRootStr);
            if (gfRoot != null && gfRoot.exists() && (domainDirName = this.dm.getProperties().getDomainDir()) != null) {
                domainDir = new File(domainDirName);
                if (TOOL_KEYSTORE.equals(toolName) || TOOL_KEYSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, KEYSTORE_LOCATION)};
                }
                if (TOOL_TRUSTSTORE.equals(toolName) || TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, TRUSTSTORE_LOCATION)};
                }
            }
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "dm has no root???", new Exception());
        }
        return new File[0];
    }

    public Set<Profile> getSupportedProfiles() {
        return this.getCorrectedProfileSet();
    }

    public Set<Profile> getSupportedProfiles(J2eeModule.Type type) {
        return this.getCorrectedProfileSet();
    }

    private Set<Profile> getCorrectedProfileSet() {
        Set<Profile> retVal = this.pf.getSupportedProfiles();
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        File descriminator = new File(gfRootStr, "modules/appclient-server-core.jar");
        if (!descriminator.exists()) {
            retVal.remove(Profile.JAVA_EE_6_FULL);
        }
        return retVal;
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        Set<J2eeModule.Type> retVal = this.pf.getSupportedTypes();
        Set<Profile> ps = this.getCorrectedProfileSet();
        if (ps.contains(Profile.JAVA_EE_6_WEB) && !ps.contains(Profile.JAVA_EE_6_FULL)) {
            retVal.remove(J2eeModule.Type.CAR);
            retVal.remove(J2eeModule.Type.EAR);
            retVal.remove(J2eeModule.Type.EJB);
            retVal.remove(J2eeModule.Type.RAR);
        }
        return retVal;
    }

    public File[] getPlatformRoots() {
        File server = this.getServerHome();
        if (server != null) {
            return new File[]{server};
        }
        return new File[0];
    }

    public File getServerHome() {
        File returnedElement;
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        if (gfRootStr != null && (returnedElement = new File(gfRootStr)).exists()) {
            return returnedElement;
        }
        return null;
    }

    public File getDomainHome() {
        return null;
    }

    public File getMiddlewareHome() {
        return null;
    }

    public LibraryImplementation[] getLibraries() {
        this.addFcl();
        return (LibraryImplementation[])this.libraries.clone();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/hk2/resources/server.gif");
    }

    public String getDisplayName() {
        return this.pf.getDisplayName();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.pf.getSupportedJavaPlatforms();
    }

    public JavaPlatform getJavaPlatform() {
        return this.pf.getJavaPlatform();
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
    }

    private void initLibraries() {
        libInitThread.post(new Runnable(){

            @Override
            public void run() {
                Hk2JavaEEPlatformImpl.this.lib.setName(Hk2JavaEEPlatformImpl.this.pf.getLibraryName());
                Hk2JavaEEPlatformImpl.this.lib.setContent("classpath", Hk2JavaEEPlatformImpl.this.dm.getProperties().getClasses());
                Hk2JavaEEPlatformImpl.this.lib.setContent("javadoc", Hk2JavaEEPlatformImpl.this.dm.getProperties().getJavadocs());
                Hk2JavaEEPlatformImpl.this.firePropertyChange("libraries", null, Hk2JavaEEPlatformImpl.this.libraries.clone());
            }
        });
    }

    public Lookup getLookup() {
        String gfRootStr = this.dm.getProperties().getGlassfishRoot();
        Lookup baseLookup = Lookups.fixed((Object[])new Object[]{gfRootStr});
        return LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)this.pf.getLookupKey());
    }

    private String quotedString(String s) {
        return "\"" + s + "\"";
    }

    public String getToolProperty(String toolName, String propertyName) {
        if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
            File root = new File(this.dm.getProperties().getGlassfishRoot());
            String domainPath = this.dm.getProperties().getDomainDir();
            if ("main.class".equals(propertyName)) {
                return "org.glassfish.appclient.client.AppClientFacade";
            }
            if ("main.class.args".equals(propertyName)) {
                return "${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(propertyName)) {
                if (domainPath != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("-Djava.endorsed.dirs=");
                    sb.append(this.quotedString(new File(root, "lib/endorsed").getAbsolutePath()));
                    sb.append(File.pathSeparator);
                    sb.append(this.quotedString(new File(root, "modules/endorsed").getAbsolutePath()));
                    sb.append(" -javaagent:");
                    String url = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("url");
                    File f = new File(root, "lib/gf-client.jar");
                    if (f.exists()) {
                        sb.append(this.quotedString(f.getAbsolutePath()));
                    } else {
                        sb.append(this.quotedString(new File(root, "modules/gf-client.jar").getAbsolutePath()));
                    }
                    sb.append("=mode=acscript,arg=-configxml,arg=");
                    sb.append(this.quotedString(new File(domainPath, "config/sun-acc.xml").getAbsolutePath()));
                    sb.append(",client=jar=");
                    return sb.toString();
                }
                return null;
            }
            if ("client.jar.location".equals(propertyName)) {
                if (domainPath != null) {
                    FileObject location = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(domainPath)));
                    if (location == null) {
                        return null;
                    }
                    return FileUtil.toFile((FileObject)location).getAbsolutePath() + File.separator + "generated" + File.separator + "xml";
                }
                return null;
            }
            if ("j2ee.appclient.args".equals(propertyName)) {
                return null;
            }
        }
        return null;
    }
}

