/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;

public class JavaVariablesFilter
extends VariablesFilterAdapter {
    private static HashSet getValueType;
    private static HashSet leafType;
    private static HashSet toStringValueType;

    public String[] getSupportedTypes() {
        return new String[]{"java.lang.String", "java.lang.StringBuffer", "java.lang.StringBuilder", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.ref.WeakReference", "java.lang.ref.SoftReference", "java.lang.ref.PhantomReference", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", "java.beans.PropertyChangeSupport"};
    }

    public String[] getSupportedAncestors() {
        return new String[0];
    }

    public Object[] getChildren(TreeModel original, Variable variable, int from, int to) throws UnknownTypeException {
        if (variable instanceof ObjectVariable) {
            ObjectVariable ov = (ObjectVariable)variable;
            JPDAClassType ct = ov.getClassType();
            if (ct == null) {
                return original.getChildren((Object)variable, from, to);
            }
            if (JavaVariablesFilter.isToArrayType(ct)) {
                try {
                    ov = (ObjectVariable)ov.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                    if (ov == null) {
                        return new Object[0];
                    }
                    return original.getChildren((Object)ov, from, to);
                }
                catch (NoSuchMethodException e) {
                    Field elementData = ov.getField("elementData");
                    if (elementData != null) {
                        return original.getChildren((Object)elementData, from, to);
                    }
                }
                catch (InvalidExpressionException e) {
                    Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(toArray) " + e.getLocalizedMessage());
                    return original.getChildren((Object)variable, from, to);
                }
            }
            if (JavaVariablesFilter.isMapMapType(ct)) {
                try {
                    ov = (ObjectVariable)ov.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                    if (ov != null && (ov = (ObjectVariable)ov.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0])) != null) {
                        return original.getChildren((Object)ov, from, to);
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvalidExpressionException e) {
                    Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(entrySet) " + e.getLocalizedMessage());
                }
            }
            if (JavaVariablesFilter.isMapEntryType(ct)) {
                Object[] fs = new Field[]{ov.getField("key"), ov.getField("value")};
                return fs;
            }
            if (JavaVariablesFilter.isInstanceOf(ct, "java.lang.ref.Reference")) {
                return new Object[]{ov.getField("referent"), ov.getField("queue")};
            }
            String type = ct.getName();
            if ("java.beans.PropertyChangeSupport".equals(type)) {
                try {
                    return ((ObjectVariable)ov.invokeMethod("getPropertyChangeListeners", "()[Ljava/beans/PropertyChangeListener;", new Variable[0])).getFields(from, to);
                }
                catch (InvalidExpressionException e) {
                    Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(getPropertyChangeListeners) " + e.getLocalizedMessage());
                }
                catch (NoSuchMethodException e) {
                    Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(getPropertyChangeListeners) " + e.getLocalizedMessage());
                }
            }
        }
        return original.getChildren((Object)variable, from, to);
    }

    public int getChildrenCount(TreeModel original, Variable variable) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel original, Variable variable) throws UnknownTypeException {
        String type = variable.getType();
        if (JavaVariablesFilter.isLeafType(type)) {
            return true;
        }
        return original.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel original, Variable variable, String columnID) throws UnknownTypeException {
        if (!(variable instanceof ObjectVariable)) {
            return original.getValueAt((Object)variable, columnID);
        }
        String type = variable.getType();
        ObjectVariable ov = (ObjectVariable)variable;
        if (JavaVariablesFilter.isMapEntryType(ov.getClassType()) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            return ov.getField("key").getValue() + "=>" + ov.getField("value").getValue();
        }
        if (JavaVariablesFilter.isGetValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            return ov.getField("value").getValue();
        }
        if (JavaVariablesFilter.isToStringValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            try {
                return "\"" + ov.getToStringValue() + "\"";
            }
            catch (InvalidExpressionException ex) {
                Logger.getLogger(JavaVariablesFilter.class.getName()).fine("getToStringValue() " + ex.getLocalizedMessage());
                if (ex.getTargetException() != null && ex.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getValueAt((Object)variable, columnID);
                }
                return ex.getLocalizedMessage();
            }
        }
        return original.getValueAt((Object)variable, columnID);
    }

    public void setValueAt(TableModel original, Variable variable, String columnID, Object value) throws UnknownTypeException {
        String expression;
        String type = variable.getType();
        if (JavaVariablesFilter.isToStringValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue") && (expression = (String)value).startsWith("\"") && expression.endsWith("\"") && expression.length() > 1) {
            expression = "new " + type + "(\"" + JavaVariablesFilter.convertToStringInitializer(expression.substring(1, expression.length() - 1)) + "\")";
            original.setValueAt((Object)variable, columnID, (Object)expression);
            return;
        }
        original.setValueAt((Object)variable, columnID, value);
    }

    private static String convertToStringInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static boolean isGetValueType(String type) {
        if (getValueType == null) {
            getValueType = new HashSet();
            getValueType.add("java.lang.Character");
            getValueType.add("java.lang.Integer");
            getValueType.add("java.lang.Float");
            getValueType.add("java.lang.Byte");
            getValueType.add("java.lang.Boolean");
            getValueType.add("java.lang.Double");
            getValueType.add("java.lang.Long");
            getValueType.add("java.lang.Short");
        }
        return getValueType.contains(type);
    }

    private static boolean isLeafType(String type) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(type);
    }

    private static boolean isToStringValueType(String type) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
            toStringValueType.add("java.lang.StringBuilder");
        }
        return toStringValueType.contains(type);
    }

    private static boolean isToArrayType(JPDAClassType ct) {
        return JavaVariablesFilter.isInstanceOf(ct, "java.util.Collection");
    }

    private static boolean isMapMapType(JPDAClassType ct) {
        return JavaVariablesFilter.isInstanceOf(ct, "java.util.Map");
    }

    private static boolean isMapEntryType(JPDAClassType ct) {
        return JavaVariablesFilter.isInstanceOf(ct, "java.util.Map$Entry");
    }

    private static boolean isInstanceOf(JPDAClassType ct, String className) {
        if (ct == null) {
            return false;
        }
        try {
            Method isInstanceOfMethod = ct.getClass().getMethod("isInstanceOf", String.class);
            return (Boolean)isInstanceOfMethod.invoke((Object)ct, className);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }
}

