/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui;

import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.PasswordAuthorizer;
import org.netbeans.modules.hudson.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FormLogin
extends JPanel {
    private JTextField locationField;
    private JLabel locationLabel;
    private JPasswordField passField;
    private JLabel passLabel;
    private JTextField userField;
    private JLabel userLabel;

    private static Preferences loginPrefs() {
        return NbPreferences.forModule(FormLogin.class).node("authentication");
    }

    private FormLogin() {
        this.initComponents();
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passLabel = new JLabel();
        this.passField = new JPasswordField();
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(FormLogin.class, (String)"FormLogin.locationLabel.text"));
        this.locationField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(FormLogin.class, (String)"FormLogin.userLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.passLabel, (String)NbBundle.getMessage(FormLogin.class, (String)"FormLogin.passLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.locationLabel).addGap(36, 36, 36).addComponent(this.locationField, -1, 301, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passLabel).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passField, -1, 299, Short.MAX_VALUE).addComponent(this.userField, -1, 299, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userField, -2, -1, -2).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passLabel).addComponent(this.passField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        (this.userField.getText().length() > 0 ? this.passField : this.userField).requestFocus();
    }

    public static class AuthImpl
    implements PasswordAuthorizer {
        @Override
        public String[] authorize(URL home) {
            FormLogin panel = new FormLogin();
            String server = HudsonManagerImpl.simplifyServerLocation(home.toString(), true);
            String username = FormLogin.loginPrefs().get(server, null);
            if (username != null) {
                panel.userField.setText(username);
                char[] savedPassword = Keyring.read((String)server);
                if (savedPassword != null) {
                    panel.passField.setText(new String(savedPassword));
                }
            }
            panel.locationField.setText(home.toString());
            DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.FormLogin_log_in());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            username = panel.userField.getText();
            FormLogin.loginPrefs().put(server, username);
            String password = new String(panel.passField.getPassword());
            panel.passField.setText("");
            Keyring.save((String)server, (char[])password.toCharArray(), (String)Bundle.FormLogin_password_description(home, username));
            return new String[]{username, password};
        }
    }
}

