/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.w3c.dom.Document;

public class HudsonJobBuildImpl
implements HudsonJobBuild,
OpenableInBrowser {
    private final HudsonJobImpl job;
    private final int build;
    private boolean building;
    private HudsonJobBuild.Result result;
    private final HudsonConnector connector;
    private Collection<? extends HudsonJobChangeItem> changes;

    HudsonJobBuildImpl(HudsonConnector connector, HudsonJobImpl job, int build, boolean building, HudsonJobBuild.Result result) {
        this.connector = connector;
        this.job = job;
        this.build = build;
        this.building = building;
        this.result = result;
    }

    @Override
    public HudsonJob getJob() {
        return this.job;
    }

    @Override
    public int getNumber() {
        return this.build;
    }

    @Override
    public String getUrl() {
        return this.job.getUrl() + this.build + "/";
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public boolean isBuilding() {
        this.getResult();
        return this.building;
    }

    @Override
    public synchronized HudsonJobBuild.Result getResult() {
        if (this.result == null && !this.building) {
            AtomicBoolean _building = new AtomicBoolean();
            AtomicReference<HudsonJobBuild.Result> _result = new AtomicReference<HudsonJobBuild.Result>(HudsonJobBuild.Result.NOT_BUILT);
            this.connector.loadResult(this, _building, _result);
            this.building = _building.get();
            this.result = _result.get();
        }
        return this.result;
    }

    @Override
    public Collection<? extends HudsonJobChangeItem> getChanges() {
        if (this.changes == null || this.changes.isEmpty()) {
            Document changeSet = this.connector.getDocument(this.getUrl() + "api/xml" + "?xpath=/*/changeSet");
            if (changeSet != null) {
                for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                    this.changes = scm.parseChangeSet(this.job, changeSet.getDocumentElement());
                    if (this.changes == null) continue;
                    break;
                }
            }
            if (this.changes == null) {
                this.changes = Collections.emptyList();
            }
        }
        return this.changes;
    }

    @Override
    public FileSystem getArtifacts() {
        return this.job.getInstance().getArtifacts(this);
    }

    @Override
    public Collection<? extends HudsonMavenModuleBuild> getMavenModules() {
        ArrayList<HudsonMavenModuleBuildImpl> modules = new ArrayList<HudsonMavenModuleBuildImpl>();
        for (HudsonJobImpl.HudsonMavenModule module : this.job.mavenModules) {
            modules.add(new HudsonMavenModuleBuildImpl(module));
        }
        return modules;
    }

    @Override
    public String getDisplayName() {
        return Bundle.HudsonJobBuildImpl_display_name(this.job.getDisplayName(), this.getNumber());
    }

    private final class HudsonMavenModuleBuildImpl
    implements HudsonMavenModuleBuild,
    OpenableInBrowser {
        private final HudsonJobImpl.HudsonMavenModule module;

        HudsonMavenModuleBuildImpl(HudsonJobImpl.HudsonMavenModule module) {
            this.module = module;
        }

        @Override
        public String getName() {
            return this.module.name;
        }

        @Override
        public String getDisplayName() {
            return this.module.displayName;
        }

        @Override
        public HudsonJob.Color getColor() {
            return this.module.color;
        }

        @Override
        public String getUrl() {
            return this.module.url + HudsonJobBuildImpl.this.build + "/";
        }

        @Override
        public HudsonJobBuild getBuild() {
            return HudsonJobBuildImpl.this;
        }

        @Override
        public FileSystem getArtifacts() {
            return HudsonJobBuildImpl.this.job.getInstance().getArtifacts(this);
        }

        public String toString() {
            return this.getUrl();
        }

        @Override
        public String getBuildDisplayName() {
            return Bundle.HudsonJobBuildImpl_display_name(this.getDisplayName(), HudsonJobBuildImpl.this.getNumber());
        }
    }
}

