/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.jpa.refactoring.util.PositionBoundsResolver;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class PersistenceXmlRefactoring
implements JPARefactoring {
    private Collection<? extends FileObject> refactoringSources;

    protected Collection<? extends FileObject> getRefactoringSources() {
        if (this.refactoringSources == null) {
            this.refactoringSources = this.lookupRefactoringSources();
        }
        return this.refactoringSources;
    }

    private Collection<? extends FileObject> lookupRefactoringSources() {
        Collection fosFromLookup = this.getRefactoring().getRefactoringSource().lookupAll(FileObject.class);
        if (!fosFromLookup.isEmpty()) {
            ArrayList<FileObject> result = new ArrayList<FileObject>();
            for (FileObject each : fosFromLookup) {
                if (each.isFolder()) {
                    PersistenceXmlRefactoring.collectChildren(each, result);
                    continue;
                }
                result.add(each);
            }
            return result;
        }
        NonRecursiveFolder folder = (NonRecursiveFolder)this.getRefactoring().getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return Collections.singleton(folder.getFolder());
        }
        TreePathHandle treePathHandle = (TreePathHandle)this.getRefactoring().getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return Collections.singleton(treePathHandle.getFileObject());
        }
        return Collections.emptySet();
    }

    public static void collectChildren(FileObject folder, List<FileObject> result) {
        for (FileObject child : folder.getChildren()) {
            if (RefactoringUtil.isJavaFile(child)) {
                result.add(child);
                continue;
            }
            if (!child.isFolder()) continue;
            PersistenceXmlRefactoring.collectChildren(child, result);
        }
    }

    protected boolean shouldHandle() {
        for (FileObject fileObject : this.getRefactoringSources()) {
            if (!this.shouldHandle(fileObject)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldHandle(FileObject refactoringSource) {
        final boolean[] result = new boolean[]{false};
        if (RefactoringUtil.isJavaFile(refactoringSource)) {
            JavaSource source = JavaSource.forFileObject((FileObject)refactoringSource);
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController info) throws Exception {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                        TreePathHandle treePathHandle = null;
                        CompilationUnitTree cut = info.getCompilationUnit();
                        if (!cut.getTypeDecls().isEmpty()) {
                            treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)info);
                        }
                        if (treePathHandle == null) {
                            result[0] = false;
                        } else {
                            Element element = treePathHandle.resolveElement((CompilationInfo)info);
                            if (element != null) {
                                result[0] = element.getKind() == ElementKind.CLASS;
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result[0];
    }

    @Override
    public final Problem preCheck() {
        if (!this.shouldHandle()) {
            return null;
        }
        Problem result = null;
        for (FileObject fileObject : this.getRefactoringSources()) {
            for (FileObject persistenceXml : this.getPersistenceXmls(fileObject)) {
                try {
                    ProviderUtil.getPUDataObject((FileObject)persistenceXml);
                }
                catch (InvalidPersistenceXmlException ex) {
                    Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ex.getPath()));
                    result = RefactoringUtil.addToEnd(newProblem, result);
                }
            }
        }
        return result;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (!this.shouldHandle()) {
            return null;
        }
        Problem result = null;
        for (FileObject fileObject : this.getRefactoringSources()) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null || !this.shouldHandle(fileObject)) continue;
            String classNameFQN = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
            for (FileObject each : this.getPersistenceXmls(fileObject)) {
                try {
                    PUDataObject pUDataObject = ProviderUtil.getPUDataObject((FileObject)each);
                    List<PersistenceUnit> punits = this.getAffectedPersistenceUnits(pUDataObject, classNameFQN);
                    for (PersistenceUnit persistenceUnit : punits) {
                        refactoringElementsBag.add(this.getRefactoring(), this.getRefactoringElement(persistenceUnit, fileObject, pUDataObject, each));
                    }
                }
                catch (InvalidPersistenceXmlException ex) {
                    Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ex.getPath()));
                    result = RefactoringUtil.addToEnd(newProblem, result);
                }
            }
        }
        return result;
    }

    protected abstract AbstractRefactoring getRefactoring();

    protected abstract RefactoringElementImplementation getRefactoringElement(PersistenceUnit var1, FileObject var2, PUDataObject var3, FileObject var4);

    protected final List<PersistenceUnit> getAffectedPersistenceUnits(PUDataObject pUDataObject, String clazz) {
        PersistenceUnit[] persistenceUnits;
        ArrayList<PersistenceUnit> result = new ArrayList<PersistenceUnit>();
        for (PersistenceUnit each : persistenceUnits = ProviderUtil.getPersistenceUnits((PUDataObject)pUDataObject)) {
            if (!PersistenceXmlRefactoring.hasClass(each, clazz)) continue;
            result.add(each);
        }
        return result;
    }

    private static boolean hasClass(PersistenceUnit persistenceUnit, String clazz) {
        for (String each : persistenceUnit.getClass2()) {
            if (!each.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    protected final List<FileObject> getPersistenceXmls(FileObject refactoringSource) {
        Project project = FileOwnerQuery.getOwner((FileObject)refactoringSource);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes((Project)project);
        for (int i = 0; i < persistenceScopes.length; ++i) {
            FileObject persistenceXmlFo = persistenceScopes[i].getPersistenceXml();
            if (persistenceXmlFo == null) continue;
            result.add(persistenceXmlFo);
        }
        return result;
    }

    protected static abstract class PersistenceXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final PersistenceUnit persistenceUnit;
        protected final PUDataObject puDataObject;
        protected final String clazz;
        protected final FileObject parentFile;

        protected PersistenceXmlRefactoringElement(PersistenceUnit persistenceUnit, String clazz, PUDataObject puDataObject, FileObject parentFile) {
            this.clazz = clazz;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = puDataObject;
            this.parentFile = parentFile;
        }

        public final String getText() {
            return this.getDisplayText();
        }

        public final Lookup getLookup() {
            return Lookups.singleton((Object)this.parentFile);
        }

        public final FileObject getParentFile() {
            return this.parentFile;
        }

        public final PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.parentFile), this.clazz).getPositionBounds();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

