/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import java.util.ArrayList;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoringPlugin;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.jpa.refactoring.moveclass.PersistenceXmlMoveClass;
import org.netbeans.modules.j2ee.jpa.refactoring.rename.EntityRename;
import org.netbeans.modules.j2ee.jpa.refactoring.rename.PersistenceXmlPackageRename;
import org.netbeans.modules.j2ee.jpa.refactoring.rename.PersistenceXmlRename;
import org.netbeans.modules.j2ee.jpa.refactoring.safedelete.PersistenceXmlSafeDelete;
import org.netbeans.modules.j2ee.jpa.refactoring.whereused.PersistenceXmlWhereUsed;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;

public class JPARefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        FileObject targetFile = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        NonRecursiveFolder pkg = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        TreePathHandle handle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        boolean folder = targetFile != null && targetFile.isFolder();
        boolean javaPackage = pkg != null && RefactoringUtil.isOnSourceClasspath(pkg.getFolder());
        boolean javaFile = targetFile != null && RefactoringUtil.isJavaFile(targetFile);
        boolean javaMember = handle != null;
        ArrayList<JPARefactoring> refactorings = new ArrayList<JPARefactoring>();
        if (refactoring instanceof RenameRefactoring) {
            RenameRefactoring rename = (RenameRefactoring)refactoring;
            if (javaFile) {
                refactorings.add(new PersistenceXmlRename(rename));
            } else if (javaPackage || folder) {
                refactorings.add(new PersistenceXmlPackageRename(rename));
            } else if (javaMember) {
                refactorings.add(new EntityRename(rename));
            }
            return new JPARefactoringPlugin(refactorings);
        }
        if (refactoring instanceof MoveRefactoring) {
            MoveRefactoring move = (MoveRefactoring)refactoring;
            refactorings.add(new PersistenceXmlMoveClass(move));
            return new JPARefactoringPlugin(refactorings);
        }
        if (refactoring instanceof SafeDeleteRefactoring) {
            SafeDeleteRefactoring safeDeleteRefactoring = (SafeDeleteRefactoring)refactoring;
            refactorings.add(new PersistenceXmlSafeDelete(safeDeleteRefactoring));
            return new JPARefactoringPlugin(refactorings);
        }
        if (refactoring instanceof WhereUsedQuery) {
            WhereUsedQuery whereUsedQuery = (WhereUsedQuery)refactoring;
            refactorings.add(new PersistenceXmlWhereUsed(whereUsedQuery));
            return new JPARefactoringPlugin(refactorings);
        }
        return null;
    }
}

