/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

public class StopTask
extends BasicTask<GlassfishModule.OperationState> {
    private final CommonServerSupport support;

    public StopTask(CommonServerSupport support, OperationStateListener ... stateListener) {
        super(support.getInstanceProperties(), stateListener);
        this.support = support;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "StopTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long start = System.currentTimeMillis();
        int port = 0;
        String host = (String)this.ip.get("host");
        if (host == null || host.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            port = Integer.valueOf((String)this.ip.get("adminPort"));
            if (port < 0 || port > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
        }
        catch (NumberFormatException ex) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        CommandRunner mgr = new CommandRunner(true, this.support.getCommandFactory(), this.ip, new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (newState == GlassfishModule.OperationState.FAILED) {
                    StopTask.this.fireOperationStateChanged(newState, message, StopTask.this.instanceName);
                }
            }
        });
        mgr.stopServer();
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        while (System.currentTimeMillis() - start < 10000L) {
            if (!CommonServerSupport.isRunning(host, port, (String)this.ip.get("displayName"))) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                LogViewMgr logger = LogViewMgr.getInstance((String)this.ip.get("url"));
                logger.stopReaders();
                return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_STOP_SERVER_FAILED", this.instanceName);
    }
}

