/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.glassfish.common.ProxySettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AdminAuthenticator
extends Authenticator {
    private boolean displayed = false;
    private static final long TIMEOUT = 3000L;
    private static long lastTry = 0L;

    public AdminAuthenticator() {
        Preferences proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
        assert (proxySettingsNode != null);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Logger.getLogger("glassfish").log(Level.FINER, "AdminAuthenticator.getPasswordAuthentication() with prompt {0}", this.getRequestingPrompt());
        String title = this.getRequestingPrompt();
        if (Authenticator.RequestorType.PROXY == this.getRequestorType() && ProxySettings.useAuthentication()) {
            Logger.getLogger("glassfish").log(Level.FINER, "Username set to {0} while request {1}", new Object[]{ProxySettings.getAuthenticationUsername(), this.getRequestingURL()});
            return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
        }
        if (System.currentTimeMillis() - lastTry > 3000L) {
            if (!"admin-realm".equals(title)) {
                this.displayed = false;
            }
            if (!this.displayed) {
                this.displayed = true;
                ResourceBundle bundle = NbBundle.getBundle(AdminAuthenticator.class);
                String dialogTitle = this.getRequestingHost();
                if (null == dialogTitle) {
                    dialogTitle = bundle.getString("CTL_PasswordProtected");
                }
                String name = "";
                PasswordPanel passwordPanel = new PasswordPanel(name);
                String url = this.getRequestingURL().toString();
                if (null == url || !url.contains("/__asadmin/")) {
                    passwordPanel.setPrompt(title);
                } else {
                    dialogTitle = bundle.getString("CTL_PasswordProtected");
                    passwordPanel.setPrompt(NbBundle.getMessage(AdminAuthenticator.class, (String)"PROMPT_GLASSFISH_AUTH", (Object)this.getRequestingHost(), (Object)Integer.valueOf(this.getRequestingPort()).toString()));
                }
                DialogDescriptor dd = new DialogDescriptor((Object)passwordPanel, dialogTitle);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                dialog.setVisible(true);
                if (dd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                    lastTry = System.currentTimeMillis();
                    return new PasswordAuthentication(passwordPanel.getUsername(), passwordPanel.getPassword());
                }
                lastTry = System.currentTimeMillis();
            }
        }
        Logger.getLogger("glassfish").log(Level.WARNING, "No authentication set while requesting {0}", this.getRequestingURL());
        return null;
    }

    static class PasswordPanel
    extends JPanel {
        private static final int DEFAULT_WIDTH = 200;
        private static final int DEFAULT_HEIGHT = 0;
        static final long serialVersionUID = 1555749205340031767L;
        ResourceBundle bundle = NbBundle.getBundle(AdminAuthenticator.class);
        private JPanel mainPanel;
        private JLabel promptLabel;
        private JLabel jLabel1;
        private JTextField usernameField;
        private JLabel jLabel2;
        private JPasswordField passwordField;

        public PasswordPanel(String userName) {
            this.initComponents();
            this.usernameField.setText(userName);
            this.usernameField.setSelectionStart(0);
            this.usernameField.setSelectionEnd(userName.length());
            this.usernameField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_UserNameField"));
            this.passwordField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_PasswordField"));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension sup = super.getPreferredSize();
            return new Dimension(Math.max(sup.width, 200), Math.max(sup.height, 0));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
            this.promptLabel = new JLabel();
            this.promptLabel.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 6, 0);
            this.mainPanel.add((Component)this.promptLabel, gridBagConstraints1);
            this.jLabel1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.bundle.getString("LAB_AUTH_User_Name"));
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 5, 12);
            gridBagConstraints1.anchor = 17;
            this.mainPanel.add((Component)this.jLabel1, gridBagConstraints1);
            this.usernameField = new JTextField();
            Font f = this.usernameField.getFont();
            FontMetrics fm = this.usernameField.getFontMetrics(f);
            int unFH = fm.getHeight() * 150 / 100;
            this.usernameField.setMinimumSize(new Dimension(70, unFH));
            this.usernameField.setPreferredSize(new Dimension(70, unFH));
            this.jLabel1.setLabelFor(this.usernameField);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            this.mainPanel.add((Component)this.usernameField, gridBagConstraints1);
            this.jLabel2 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.bundle.getString("LAB_AUTH_Password"));
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints1);
            this.passwordField = new JPasswordField();
            this.passwordField.setMinimumSize(new Dimension(70, unFH));
            this.passwordField.setPreferredSize(new Dimension(70, unFH));
            this.jLabel2.setLabelFor(this.passwordField);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            this.mainPanel.add((Component)this.passwordField, gridBagConstraints1);
            this.add((Component)this.mainPanel, "Center");
        }

        String getUsername() {
            return this.usernameField.getText();
        }

        char[] getPassword() {
            return this.passwordField.getPassword();
        }

        String getTPassword() {
            return this.passwordField.getText();
        }

        void setPrompt(String prompt) {
            if (prompt == null) {
                this.promptLabel.setVisible(false);
                this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_NbAuthenticatorPasswordPanel"));
            } else {
                this.promptLabel.setVisible(true);
                this.promptLabel.setText(prompt);
                this.getAccessibleContext().setAccessibleDescription(prompt);
            }
        }
    }
}

