/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class WebCopyOnSave
extends CopyOnSave
implements PropertyChangeListener {
    private FileObject docBase = null;
    boolean active = false;
    private static final RequestProcessor COS_PROCESSOR = new RequestProcessor("Maven Copy on Save", 5);
    FileChangeListener listener = new FileListenerImpl();

    WebCopyOnSave(Project prj, WebModuleProviderImpl prov) {
        super(prj, prov);
    }

    private WebModule getWebModule() {
        return ((WebModuleProviderImpl)this.getJ2eeModuleProvider()).findWebModule(this.getProject().getProjectDirectory());
    }

    private boolean isInPlace() throws IOException {
        FileObject fo = this.getJ2eeModule().getContentDirectory();
        return fo != null && fo.equals(this.getWebModule().getDocumentBase());
    }

    @Override
    public void initialize() throws FileStateInvalidException {
        if (!this.active) {
            this.smallinitialize();
            NbMavenProject.addPropertyChangeListener((Project)this.getProject(), (PropertyChangeListener)this);
            this.active = true;
        }
    }

    @Override
    public void cleanup() throws FileStateInvalidException {
        if (this.active) {
            this.smallcleanup();
            NbMavenProject.removePropertyChangeListener((Project)this.getProject(), (PropertyChangeListener)this);
            this.active = false;
        }
    }

    private void smallinitialize() throws FileStateInvalidException {
        this.docBase = this.getWebModule().getDocumentBase();
        if (this.docBase != null) {
            this.docBase.getFileSystem().addFileChangeListener(this.listener);
        }
    }

    private void smallcleanup() throws FileStateInvalidException {
        if (this.docBase != null) {
            this.docBase.getFileSystem().removeFileChangeListener(this.listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName())) {
            try {
                if (this.active) {
                    this.smallcleanup();
                    this.smallinitialize();
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private boolean isSynchronizationAppropriate(String filePath) {
        if (filePath.startsWith("WEB-INF/classes")) {
            return false;
        }
        if (filePath.startsWith("WEB-INF/src")) {
            return false;
        }
        return !filePath.startsWith("WEB-INF/lib");
    }

    private void handleDeleteFileInDestDir(FileObject fo, String path) throws IOException {
        FileObject root = this.findWebDocRoot(fo);
        if (root != null) {
            FileObject toDelete;
            String string = path = path != null ? path : FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (!this.isSynchronizationAppropriate(path)) {
                return;
            }
            FileObject webBuildBase = this.getJ2eeModule().getContentDirectory();
            if (webBuildBase != null && (toDelete = webBuildBase.getFileObject(path)) != null) {
                File fil = FileUtil.toFile((FileObject)toDelete);
                toDelete.delete();
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fo) throws IOException {
        FileObject documentBase;
        if (!fo.isVirtual() && (documentBase = this.findWebDocRoot(fo)) != null) {
            String path = FileUtil.getRelativePath((FileObject)documentBase, (FileObject)fo);
            if (!this.isSynchronizationAppropriate(path)) {
                return;
            }
            FileObject webBuildBase = this.getJ2eeModule().getContentDirectory();
            if (webBuildBase != null) {
                if (FileUtil.isParentOf((FileObject)documentBase, (FileObject)webBuildBase) || FileUtil.isParentOf((FileObject)webBuildBase, (FileObject)documentBase)) {
                    return;
                }
                FileObject destFile = this.ensureDestinationFileExists(webBuildBase, path, fo.isFolder());
                File fil = FileUtil.toFile((FileObject)destFile);
                this.copySrcToDest(fo, destFile);
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
            }
        }
    }

    private FileObject findWebDocRoot(FileObject child) {
        FileObject documentBase = this.getWebModule().getDocumentBase();
        if (documentBase != null && FileUtil.isParentOf((FileObject)documentBase, (FileObject)child)) {
            return documentBase;
        }
        return null;
    }

    @Override
    protected String getDestinationSubFolderName() {
        return "WEB-INF/classes";
    }

    private class FileListenerImpl
    extends FileChangeAdapter {
        private FileListenerImpl() {
        }

        public void fileChanged(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                COS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileChanged(fe);
                    }
                });
                return;
            }
            try {
                if (!WebCopyOnSave.this.isInPlace()) {
                    WebCopyOnSave.this.handleCopyFileToDestDir(fe.getFile());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileDataCreated(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                COS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileDataCreated(fe);
                    }
                });
                return;
            }
            try {
                if (!WebCopyOnSave.this.isInPlace()) {
                    WebCopyOnSave.this.handleCopyFileToDestDir(fe.getFile());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileRenamed(final FileRenameEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                COS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileRenamed(fe);
                    }
                });
                return;
            }
            try {
                if (WebCopyOnSave.this.isInPlace()) {
                    return;
                }
                FileObject fo = fe.getFile();
                FileObject base = WebCopyOnSave.this.findWebDocRoot(fo);
                if (base != null) {
                    WebCopyOnSave.this.handleCopyFileToDestDir(fo);
                    FileObject parent = fo.getParent();
                    String path = FileUtil.isParentOf((FileObject)base, (FileObject)parent) ? FileUtil.getRelativePath((FileObject)base, (FileObject)fo.getParent()) + "/" + fe.getName() + "." + fe.getExt() : fe.getName() + "." + fe.getExt();
                    if (!WebCopyOnSave.this.isSynchronizationAppropriate(path)) {
                        return;
                    }
                    WebCopyOnSave.this.handleDeleteFileInDestDir(fo, path);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileDeleted(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                COS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileDeleted(fe);
                    }
                });
                return;
            }
            try {
                if (WebCopyOnSave.this.isInPlace()) {
                    return;
                }
                FileObject fo = fe.getFile();
                WebCopyOnSave.this.handleDeleteFileInDestDir(fo, null);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }
}

