/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MissingJavaEEForUnitTestExecutionHint
extends AbstractHint {
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.MEMBER_SELECT, Tree.Kind.IDENTIFIER);

    public MissingJavaEEForUnitTestExecutionHint() {
        super(true, true, AbstractHint.HintSeverity.ERROR, new String[0]);
    }

    public String getDescription() {
        return NbBundle.getMessage(MissingJavaEEForUnitTestExecutionHint.class, (String)"MissingJavaEEForUnitTestExecutionHint_Description");
    }

    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        Element el = info.getTrees().getElement(treePath);
        if (el == null) {
            return null;
        }
        if (el.asType() == null || !el.asType().getKind().equals((Object)TypeKind.DECLARED)) {
            return null;
        }
        if (!this.isEEType(info, el.asType())) {
            return null;
        }
        String name = ((Object)el.asType()).toString();
        FileObject testFile = info.getFileObject();
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        if (prj == null) {
            return null;
        }
        NbMavenProject mp = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (mp == null) {
            return null;
        }
        List testRoots = mp.getMavenProject().getTestCompileSourceRoots();
        String path = FileUtil.getFileDisplayName((FileObject)testFile);
        boolean unitTest = false;
        for (String testRoot : testRoots) {
            if (!path.startsWith(testRoot)) continue;
            unitTest = true;
            break;
        }
        if (!unitTest) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)testFile, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        boolean javaeeJar = false;
        boolean gfServer = false;
        for (FileObject cpRoot : cp.getRoots()) {
            FileObject fo = FileUtil.getArchiveFile((FileObject)cpRoot);
            if (fo == null) continue;
            if (fo.getNameExt().toLowerCase().contains("javaee-web-api-6.0") || fo.getNameExt().toLowerCase().contains("javaee-api-6.0")) {
                javaeeJar = true;
            }
            if (!fo.getNameExt().toLowerCase().contains("glassfish-embedded-static-shell") && !fo.getNameExt().toLowerCase().contains("glassfish-embedded-all")) continue;
            return null;
        }
        try {
            cp.getClassLoader(true).loadClass(name);
            return null;
        }
        catch (ClassFormatError tt) {
        }
        catch (ClassNotFoundException tt) {
            return null;
        }
        Tree t = treePath.getLeaf();
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(javaeeJar), new ArrayList(), (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t))));
    }

    private boolean isEEType(CompilationInfo info, TypeMirror type) {
        if (type == null) {
            return false;
        }
        if (this.isEEType(type)) {
            return true;
        }
        List<? extends TypeMirror> l = info.getTypes().directSupertypes(type);
        for (TypeMirror typeMirror : l) {
            if (!this.isEEType(info, typeMirror)) continue;
            return true;
        }
        return false;
    }

    private boolean isEEType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        String name = ((Object)type).toString();
        return name.startsWith("javax.");
    }

    public String getId() {
        return "MissingJavaEEForUnitTestExecutionHint";
    }

    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean javaeeJar) {
        if (javaeeJar) {
            return NbBundle.getMessage(MissingJavaEEForUnitTestExecutionHint.class, (String)"MissingJavaEEForUnitTestExecutionHint_DisplayName2");
        }
        return NbBundle.getMessage(MissingJavaEEForUnitTestExecutionHint.class, (String)"MissingJavaEEForUnitTestExecutionHint_DisplayName");
    }

    public void cancel() {
    }
}

