/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.spi.moduleinfo.JPAModuleInfo;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider2;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.openide.util.ChangeSupport;

class JPAStuffImpl
implements JPAModuleInfo,
JPADataSourcePopulator,
JPADataSourceProvider,
ServerStatusProvider2 {
    private final Project project;
    private ChangeSupport support = new ChangeSupport((Object)this);

    JPAStuffImpl(Project project) {
        this.project = project;
    }

    public JPAModuleInfo.ModuleType getType() {
        EjbModuleProviderImpl im = (EjbModuleProviderImpl)((Object)this.project.getLookup().lookup(EjbModuleProviderImpl.class));
        if (im != null) {
            return JPAModuleInfo.ModuleType.EJB;
        }
        WebModuleProviderImpl im2 = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        if (im2 != null) {
            return JPAModuleInfo.ModuleType.WEB;
        }
        throw new IllegalStateException("Wrong placement of JPAModuleInfo in maven project " + this.project.getProjectDirectory());
    }

    public String getVersion() {
        EjbModuleProviderImpl im = (EjbModuleProviderImpl)((Object)this.project.getLookup().lookup(EjbModuleProviderImpl.class));
        if (im != null) {
            return im.getModuleImpl().getModuleVersion();
        }
        WebModuleProviderImpl im2 = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        if (im2 != null) {
            return im2.getWebModuleImplementation().getModuleVersion();
        }
        throw new IllegalStateException("Wrong placement of JPAModuleInfo in maven project " + this.project.getProjectDirectory());
    }

    public Boolean isJPAVersionSupported(String version) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (platform == null) {
            return null;
        }
        return platform.isToolSupported("jpaversionverification") ? Boolean.valueOf(platform.isToolSupported("jpa" + version)) : null;
    }

    public void connect(JComboBox comboBox) {
        J2eeModuleProvider prvd = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        DatasourceUIHelper.connect((Project)this.project, (J2eeModuleProvider)prvd, (JComboBox)comboBox);
    }

    public List<JPADataSource> getDataSources() {
        J2eeModuleProvider prvd = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        ArrayList datasources = new ArrayList();
        try {
            datasources.addAll(prvd.getModuleDatasources());
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            datasources.addAll(prvd.getServerDatasources());
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        ArrayList<JPADataSource> result = new ArrayList<JPADataSource>(datasources.size());
        for (Datasource each : datasources) {
            result.add(new DatasourceWrapper(each));
        }
        return result;
    }

    public JPADataSource toJPADataSource(Object dataSource) {
        if (dataSource instanceof JPADataSource) {
            return (JPADataSource)dataSource;
        }
        if (dataSource instanceof Datasource) {
            return new DatasourceWrapper((Datasource)dataSource);
        }
        return null;
    }

    public boolean validServerInstancePresent() {
        J2eeModuleProvider prvd = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return prvd != null && Util.isValidServerInstance((J2eeModuleProvider)prvd);
    }

    public boolean selectServer() {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        boolean res = ExecutionChecker.showServerSelectionDialog(this.project, provider, null);
        if (res) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPAStuffImpl.this.support.fireChange();
                }
            });
        }
        return res;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    private static class DatasourceWrapper
    implements Datasource,
    JPADataSource {
        private Datasource delegate;

        DatasourceWrapper(Datasource datasource) {
            this.delegate = datasource;
        }

        public String getJndiName() {
            return this.delegate.getJndiName();
        }

        public String getUrl() {
            return this.delegate.getUrl();
        }

        public String getUsername() {
            return this.delegate.getUsername();
        }

        public String getPassword() {
            return this.delegate.getPassword();
        }

        public String getDriverClassName() {
            return this.delegate.getDriverClassName();
        }

        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

