/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.checkedtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;

public class Root
implements AbstractRoot {
    private Map<String, AbstractRoot> children = new HashMap<String, AbstractRoot>();
    private final String name;
    private final String folder;
    private final FileSystem fileStystem;
    private List<String> files;

    public Root(String name, String folder, FileSystem fileStystem) {
        this.name = name;
        this.folder = folder;
        this.fileStystem = fileStystem;
    }

    @Override
    public Collection<AbstractRoot> getChildren() {
        return this.children.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFolder() {
        return CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileStystem, (String)this.folder);
    }

    private Root getChild(String child) {
        return (Root)this.children.get(child);
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        if (this.files == null) {
            this.files = files;
        }
    }

    public Root addChild(String child) {
        Root current = this;
        StringTokenizer st = new StringTokenizer(child, "/\\");
        StringBuilder path = new StringBuilder();
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (path.length() > 0) {
                path.append('/');
            } else if (segment.length() <= 1 || segment.charAt(1) != ':') {
                path.append('/');
            }
            path.append(segment);
            if (st.hasMoreTokens()) {
                Root found = current.getChild(segment);
                if (found == null) {
                    found = new Root(segment, path.toString(), this.fileStystem);
                    current.children.put(segment, found);
                }
                current = found;
                continue;
            }
            List<String> fileList = current.getFiles();
            if (fileList == null) {
                fileList = new ArrayList<String>();
                current.setFiles(fileList);
            }
            fileList.add(child);
        }
        return current;
    }
}

