/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.SelectModeWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SelectModePanel
extends JPanel {
    private boolean first = true;
    private boolean lastApplicable;
    private SelectModeWizard wizard;
    private JRadioButton advancedMode;
    private ButtonGroup buttonGroup1;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel modeLabel;
    private JRadioButton simpleMode;

    public SelectModePanel(SelectModeWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.addListeners();
    }

    private void addListeners() {
        this.simpleMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.updateInstruction();
            }
        });
        this.advancedMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.updateInstruction();
            }
        });
        this.updateInstruction();
    }

    private void updateInstruction() {
        if (this.simpleMode.isSelected()) {
            this.instructionsTextArea.setText(this.getString("SelectModeSimpleInstructionText"));
        } else {
            this.instructionsTextArea.setText(this.getString("SelectModeAdvancedInstructionText"));
        }
        this.wizard.stateChanged(null);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.modeLabel = new JLabel();
        this.simpleMode = new JRadioButton();
        this.advancedMode = new JRadioButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)bundle.getString("SelectModeLabelText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modeLabel, gridBagConstraints);
        this.buttonGroup1.add(this.simpleMode);
        this.simpleMode.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)bundle.getString("SimpleModeButtonText"));
        this.simpleMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.simpleMode, gridBagConstraints);
        this.buttonGroup1.add(this.advancedMode);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedMode, (String)bundle.getString("AdvancedModeButtonText"));
        this.advancedMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.advancedMode, gridBagConstraints);
        this.instructionPanel.setLayout(new BorderLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        this.instructionPanel.add((Component)this.instructionsTextArea, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
        this.updateControls();
    }

    void updateControls() {
        if (!this.first) {
            if (this.lastApplicable) {
                this.advancedMode.setEnabled(true);
                this.simpleMode.setEnabled(true);
                if (this.first) {
                    this.simpleMode.setSelected(true);
                }
            } else {
                this.advancedMode.setEnabled(true);
                this.simpleMode.setEnabled(true);
                this.advancedMode.setSelected(true);
            }
        } else {
            this.advancedMode.setEnabled(true);
            this.simpleMode.setEnabled(true);
            this.simpleMode.setSelected(true);
        }
        this.updateInstruction();
    }

    void enableControls(boolean enable) {
        this.advancedMode.setEnabled(enable);
        this.simpleMode.setEnabled(enable);
    }

    boolean isApplicable(DiscoveryDescriptor wizardDescriptor) {
        if (this.first && this.simpleMode.isSelected()) {
            this.lastApplicable = new DiscoveryExtension().isApplicable(wizardDescriptor).isApplicable();
            if (!this.lastApplicable) {
                wizardDescriptor.setSimpleMode(false);
            }
            this.first = false;
        }
        return this.lastApplicable;
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        wizardDescriptor.setSimpleMode(this.simpleMode.isSelected());
    }

    boolean valid(DiscoveryDescriptor wizardDescriptor) {
        if (this.first) {
            return true;
        }
        if (this.simpleMode.isSelected() && !this.lastApplicable) {
            String selectedExecutable = wizardDescriptor.getBuildResult();
            if (selectedExecutable == null || selectedExecutable.length() == 0) {
                wizardDescriptor.setMessage(this.getString("SimpleMode.Error.NoOutputResult"));
                return false;
            }
            File file = new File(selectedExecutable);
            if (!file.exists()) {
                wizardDescriptor.setMessage(this.getString("SimpleMode.Error.OutputResultNotExist"));
                return false;
            }
            wizardDescriptor.setMessage(this.getString("SimpleMode.Error.NoDebugOutputResult"));
            return false;
        }
        return true;
    }

    private String getString(String key) {
        return NbBundle.getBundle(SelectModePanel.class).getString(key);
    }
}

