/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.CreateDependencies;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportExecutable
implements PropertyChangeListener {
    private static final boolean DLL_FILE_SEARCH = true;
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 2);
    private final Map<String, Object> map;
    private Project lastSelectedProject;
    private final IteratorExtension.ProjectKind projectKind;
    private CreateDependencies cd;
    private final boolean createProjectMode;
    private String sourcesPath;
    private boolean addSourceRoot;
    private List<String> dependencies;
    private static final List<CsmProgressListener> listeners = new ArrayList<CsmProgressListener>(1);

    public ImportExecutable(Map<String, Object> map, Project lastSelectedProject, IteratorExtension.ProjectKind projectKind) {
        this.map = map;
        this.lastSelectedProject = lastSelectedProject;
        this.projectKind = projectKind;
        if (lastSelectedProject == null) {
            this.createProjectMode = true;
            this.postCreateProject();
        } else {
            this.addSourceRoot = true;
            this.createProjectMode = false;
        }
    }

    private void postCreateProject() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportExecutable.class, (String)"ImportExecutable.Progress.ProjectCreating"));
                progress.start();
                try {
                    ImportExecutable.this.createProject();
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private void createProject() {
        String baseDir;
        String binaryPath = (String)this.map.get("outputTextField");
        this.sourcesPath = (String)this.map.get("sourceFolderPath");
        File projectFolder = (File)this.map.get("projdir");
        String projectName = (String)this.map.get("name");
        this.dependencies = (List)this.map.get("dependencies");
        if (projectFolder != null) {
            projectFolder = CndFileUtils.normalizeFile((File)projectFolder);
            baseDir = projectFolder.getAbsolutePath();
            if (projectName == null) {
                projectName = projectFolder.getName();
            }
        } else {
            String projectParentFolder = ProjectGenerator.getDefaultProjectFolder();
            if (projectName == null) {
                projectName = ProjectGenerator.getValidProjectName((String)projectParentFolder, (String)new File(binaryPath).getName());
            }
            baseDir = projectParentFolder + File.separator + projectName;
            projectFolder = CndFileUtils.createLocalFile((String)baseDir);
        }
        String hostUID = (String)this.map.get("hostUID");
        CompilerSet toolchain = (CompilerSet)this.map.get("toolchain");
        boolean defaultToolchain = Boolean.TRUE.equals(this.map.get("toolchainDefault"));
        MakeConfiguration conf = new MakeConfiguration(projectFolder.getPath(), "Default", 0, hostUID, toolchain, defaultToolchain);
        String workingDirRel = ProjectSupport.toProperPath((String)CndPathUtilitities.naturalizeSlashes((String)baseDir), (String)this.sourcesPath, (MakeProjectOptions.PathMode)MakeProjectOptions.getPathMode());
        conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        String exe = binaryPath;
        exe = CndPathUtilitities.toRelativePath((String)CndPathUtilitities.naturalizeSlashes((String)baseDir), (String)exe);
        exe = CndPathUtilitities.normalizeSlashes((String)exe);
        conf.getMakefileConfiguration().getOutput().setValue(exe);
        String exePath = new File(binaryPath).getParentFile().getAbsolutePath();
        exePath = CndPathUtilitities.toRelativePath((String)CndPathUtilitities.naturalizeSlashes((String)baseDir), (String)exePath);
        exePath = CndPathUtilitities.normalizeSlashes((String)exePath);
        conf.getProfile().setRunDirectory(exePath);
        conf.getProfile().setBuildFirst(false);
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, projectFolder);
        prjParams.setOpenFlag(false).setConfiguration(conf).setImportantFiles(Collections.singletonList(binaryPath).iterator()).setMakefileName("");
        Boolean trueSourceRoot = (Boolean)this.map.get("trueSourceRoot");
        if (trueSourceRoot != null && trueSourceRoot.booleanValue()) {
            ArrayList<2> list = new ArrayList<2>();
            list.add(new SourceFolderInfo(){

                public FileObject getFileObject() {
                    return CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)ImportExecutable.this.sourcesPath));
                }

                public String getFolderName() {
                    return this.getFileObject().getNameExt();
                }

                public boolean isAddSubfoldersSelected() {
                    return true;
                }
            });
            prjParams.setSourceFolders(list.iterator());
        } else {
            this.addSourceRoot = true;
        }
        prjParams.setSourceFoldersFilter("^(nbproject)$");
        try {
            this.lastSelectedProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            this.map.put("DW:buildResult", binaryPath);
            this.map.put("DW:consolidationLevel", "file");
            this.map.put("DW:rootFolder", this.lastSelectedProject.getProjectDirectory().getPath());
            OpenProjects.getDefault().open(new Project[]{this.lastSelectedProject}, false);
            OpenProjects.getDefault().setMainProject(this.lastSelectedProject);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            if (this.lastSelectedProject == null) {
                return;
            }
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                this.process((DiscoveryExtension)extension);
            }
        }
    }

    public void process(final DiscoveryExtension extension) {
        ImportExecutable.switchModel(false, this.lastSelectedProject);
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FileObject toFileObject;
                    DiscoveryExtensionInterface.Applicable applicable;
                    block13: {
                        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getBundle(ImportExecutable.class).getString("ImportExecutable.Progress"));
                        progress.start();
                        applicable = null;
                        try {
                            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)ImportExecutable.this.lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                            MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor(true);
                            applicable = extension.isApplicable(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject);
                            if (!applicable.isApplicable()) break block13;
                            if (ImportExecutable.this.sourcesPath == null) {
                                ImportExecutable.this.sourcesPath = applicable.getSourceRoot();
                            }
                            if (ImportExecutable.this.addSourceRoot && ImportExecutable.this.sourcesPath != null && ImportExecutable.this.sourcesPath.length() > 1) {
                                configurationDescriptor.addSourceRoot(ImportExecutable.this.sourcesPath);
                            }
                            if (!ImportExecutable.this.createProjectMode) {
                                ImportExecutable.resetCompilerSet(configurationDescriptor.getActiveConfiguration(), applicable);
                            }
                            String additionalDependencies = null;
                            if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.IncludeDependencies && (additionalDependencies = ImportExecutable.this.additionalDependencies(applicable, configurationDescriptor.getActiveConfiguration(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult())) != null && !additionalDependencies.isEmpty()) {
                                ImportExecutable.this.map.put("DW:libraries", additionalDependencies);
                            }
                            if (!extension.canApply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject)) break block13;
                            try {
                                extension.apply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject);
                                ImportExecutable.discoverScripts(ImportExecutable.this.lastSelectedProject);
                                DiscoveryManagerImpl.saveMakeConfigurationDescriptor(ImportExecutable.this.lastSelectedProject);
                                if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.CreateDependencies && (additionalDependencies == null || additionalDependencies.isEmpty())) {
                                    ImportExecutable.this.cd = new CreateDependencies(ImportExecutable.this.lastSelectedProject, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getDependencies(), ImportExecutable.this.dependencies, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getSearchPaths(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult());
                                }
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                        finally {
                            progress.finish();
                        }
                    }
                    DiscoveryExtensionInterface.Position mainFunction = applicable.getMainFunction();
                    boolean open = true;
                    if (mainFunction != null && (toFileObject = CndFileUtils.toFileObject((CharSequence)mainFunction.getFilePath())) != null && toFileObject.isValid() && CsmUtilities.openSource((FileObject)toFileObject, (int)mainFunction.getLine(), (int)0)) {
                        open = false;
                    }
                    ImportExecutable.switchModel(true, ImportExecutable.this.lastSelectedProject);
                    String main = open ? "main" : null;
                    ImportExecutable.this.onProjectParsingFinished(main, ImportExecutable.this.lastSelectedProject);
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        RP.post(run);
    }

    private static void discoverScripts(Project project) {
        File[] listFiles;
        File parentFile;
        DiscoveredConfigure parentConfigure;
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (provider == null) {
            return;
        }
        MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor(true);
        if (configurationDescriptor == null) {
            return;
        }
        MakeConfiguration activeConfiguration = configurationDescriptor.getActiveConfiguration();
        if (activeConfiguration == null) {
            return;
        }
        String root = ImportExecutable.findFolderPath(configurationDescriptor, ImportExecutable.getRoot(configurationDescriptor));
        if (root == null) {
            return;
        }
        File rootFile = new File(root);
        DiscoveredConfigure configure = ImportExecutable.scanFolder(rootFile);
        if ((configure.script == null || configure.makefile == null) && (parentConfigure = ImportExecutable.scanFolder(parentFile = rootFile.getParentFile())).script != null && parentConfigure.makefile != null && configure.scriptWeight < parentConfigure.scriptWeight) {
            configure = parentConfigure;
        }
        if ((configure.script == null || configure.makefile == null) && (listFiles = rootFile.listFiles()) != null) {
            for (File file : listFiles) {
                DiscoveredConfigure childConfigure;
                if (!file.isDirectory() || (childConfigure = ImportExecutable.scanFolder(file)).script == null || childConfigure.makefile == null || configure.scriptWeight >= childConfigure.scriptWeight) continue;
                configure = childConfigure;
            }
        }
        if (configure.makefile != null) {
            activeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(configure.makefile.getParentFile().getAbsolutePath());
            activeConfiguration.getMakefileConfiguration().getBuildCommand().setValue("${MAKE} -f " + configure.makefile.getName());
            activeConfiguration.getMakefileConfiguration().getCleanCommand().setValue("${MAKE} -f " + configure.makefile.getName() + " clean");
            Folder externalItemFolder = configurationDescriptor.getExternalItemFolder();
            for (File file : externalItemFolder.getAllItemsAsArray()) {
                if (!"text/x-make".equals(file.getMIMEType())) continue;
                externalItemFolder.removeItem((Item)file);
                break;
            }
            externalItemFolder.addItem(Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)configure.makefile.getAbsolutePath()));
            if (configure.script != null) {
                externalItemFolder.addItem(Item.createInFileSystem((FileSystem)configurationDescriptor.getBaseDirFileSystem(), (String)configure.script.getAbsolutePath()));
            }
        }
    }

    private static DiscoveredConfigure scanFolder(File rootFile) {
        DiscoveredConfigure configure = new DiscoveredConfigure();
        File[] listFiles = rootFile.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (!file.isFile()) continue;
                String name = file.getName();
                if ("CMakeLists.txt".equals(name)) {
                    configure.setScript(file, 3);
                    continue;
                }
                if (name.endsWith(".pro")) {
                    configure.setScript(file, 4);
                    continue;
                }
                if ("configure".equals(name) || "configure.exe".equals(name)) {
                    configure.setScript(file, 5);
                    continue;
                }
                if ("Makefile".equals(name)) {
                    configure.setMakefile(file, 5);
                    continue;
                }
                if ("makefile".equals(name)) {
                    configure.setMakefile(file, 4);
                    continue;
                }
                if ("GNUmakefile".equals(name)) {
                    configure.setMakefile(file, 3);
                    continue;
                }
                if (!name.endsWith(".mk")) continue;
                configure.setMakefile(file, 2);
            }
        }
        return configure;
    }

    private String additionalDependencies(DiscoveryExtensionInterface.Applicable applicable, MakeConfiguration activeConfiguration, String binary) {
        if (this.dependencies == null) {
            String root = this.sourcesPath;
            if (root == null || root.length() == 0) {
                root = applicable.getSourceRoot();
            }
            if (root == null || root.length() == 0) {
                return null;
            }
            if (applicable.getDependencies() == null || applicable.getDependencies().isEmpty()) {
                return null;
            }
            HashMap<String, String> dllPaths = new HashMap<String, String>();
            String ldLibPath = CommonUtilities.getLdLibraryPath((MakeConfiguration)activeConfiguration);
            ldLibPath = CommonUtilities.addSearchPaths((String)ldLibPath, applicable.getSearchPaths(), (String)binary);
            boolean search = false;
            for (String dll : applicable.getDependencies()) {
                String p = ImportExecutable.findLocation(dll, ldLibPath);
                if (p != null) {
                    dllPaths.put(dll, p);
                    continue;
                }
                search = true;
                dllPaths.put(dll, null);
            }
            if (search && root.length() > 1) {
                ImportExecutable.gatherSubFolders(new File(root), new HashSet<String>(), dllPaths);
            }
            StringBuilder buf = new StringBuilder();
            String binaryDir = CndPathUtilitities.getDirName((String)binary);
            for (Map.Entry entry : dllPaths.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), root) && !ImportExecutable.isMyDll((String)entry.getValue(), binaryDir)) continue;
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append((String)entry.getValue());
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        for (String path : this.dependencies) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(path);
        }
        return buf.toString();
    }

    private void onProjectParsingFinished(final String functionName, final Project makeProject) {
        if (makeProject != null) {
            final NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    if (project.getPlatformProject().equals(np)) {
                        String from;
                        Collection decls;
                        Iterator i$;
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove((Object)this);
                        if (project instanceof ProjectBase && functionName != null && (i$ = (decls = ((ProjectBase)project).findDeclarationsByPrefix(from = Utils.getCsmDeclarationKindkey((CsmDeclaration.Kind)CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + functionName + '(')).iterator()).hasNext()) {
                            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)i$.next();
                            CsmUtilities.openSource((CsmObject)decl);
                        }
                        DiscoveryManagerImpl.fixExcludedHeaderFiles(makeProject, ImportProject.logger);
                        if (ImportExecutable.this.cd != null) {
                            ImportExecutable.this.cd.create();
                        }
                    }
                }
            };
            listeners.add((CsmProgressListener)listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }

    static void switchModel(boolean state, Project makeProject) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl && makeProject != null) {
            NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                ((ModelImpl)model).enableProject(np);
            } else {
                ((ModelImpl)model).disableProject(np);
            }
        }
    }

    static void resetCompilerSet(MakeConfiguration configuration, DiscoveryExtensionInterface.Applicable applicable) {
        if (configuration != null) {
            CompilerSetManager manager = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment());
            if (applicable.isSunStudio()) {
                CompilerSet def = manager.getDefaultCompilerSet();
                if (def != null && def.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List compilerSets = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                def = null;
                for (CompilerSet set : compilerSets) {
                    if (!set.getCompilerFlavor().isSunStudioCompiler()) continue;
                    if ("OracleSolarisStudio".equals(set.getName())) {
                        def = set;
                    }
                    if (def != null) continue;
                    def = set;
                }
                if (def != null) {
                    configuration.getCompilerSet().setValue(def.getName());
                }
            } else {
                CompilerSet def = manager.getDefaultCompilerSet();
                if (def != null && !def.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List compilerSets = CompilerSetManager.get((ExecutionEnvironment)configuration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                def = null;
                for (CompilerSet set : compilerSets) {
                    if (set.getCompilerFlavor().isSunStudioCompiler() || def != null) continue;
                    def = set;
                }
                if (def != null) {
                    configuration.getCompilerSet().setValue(def.getName());
                }
            }
        }
    }

    static boolean isMyDll(String path, String root) {
        if (path.startsWith(root)) {
            return true;
        }
        String[] p1 = path.split("/");
        String[] p2 = root.split("/");
        for (int i = 0; i < Math.min(p1.length - 1, p2.length); ++i) {
            if (p1[i].equals(p2[i])) continue;
            return i > 2;
        }
        return false;
    }

    static String findLocation(String dll, String ldPath) {
        if (ldPath != null) {
            String separator = ":";
            if (ldPath.indexOf(59) > 0) {
                separator = ";";
            }
            for (String search : ldPath.split(separator)) {
                File file = new File(search, dll);
                if (!file.isFile() || !file.exists()) continue;
                String path = file.getAbsolutePath();
                return path.replace('\\', '/');
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void gatherSubFolders(File d, HashSet<String> set, Map<String, String> result) {
        if (!d.exists() || !d.isDirectory() || !d.canRead()) return;
        String path = d.getAbsolutePath();
        if (set.contains(path = path.replace('\\', '/'))) return;
        set.add(path);
        File[] ff = d.listFiles();
        if (ff == null) return;
        for (int i = 0; i < ff.length; ++i) {
            String name;
            try {
                String canPath = ff[i].getCanonicalPath();
                String absPath = ff[i].getAbsolutePath();
                if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                    continue;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (result.containsKey(name = ff[i].getName())) {
                result.put(name, ff[i].getAbsolutePath());
            }
            ImportExecutable.gatherSubFolders(ff[i], set, result);
        }
    }

    static Folder getRoot(MakeConfigurationDescriptor configurationDescriptor) {
        Folder folder = configurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles()) continue;
            if ("SourceFiles".equals(sub.getName())) {
                return sub;
            }
            if ("HeaderFiles".equals(sub.getName()) || "ResourceFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }

    static String findFolderPath(MakeConfigurationDescriptor configurationDescriptor, Folder root) {
        if (root == null) {
            return null;
        }
        if (root.isDiskFolder()) {
            String AbsRootPath = CndPathUtilitities.toAbsolutePath((String)configurationDescriptor.getBaseDir(), (String)root.getRoot());
            return RemoteFileUtil.normalizeAbsolutePath((String)AbsRootPath, (Project)configurationDescriptor.getProject());
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (Object o : root.getElements()) {
            Folder f;
            String res;
            if (!(o instanceof Folder) || (res = ImportExecutable.findFolderPath(f = (Folder)o, "/" + f.getName())) == null) continue;
            candidates.add(res + "/" + f.getName());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (String)candidates.get(0);
        }
        String bestCandidate = null;
        for (String candidate : candidates) {
            if (bestCandidate == null) {
                bestCandidate = candidate;
                continue;
            }
            if (bestCandidate.startsWith(candidate)) {
                bestCandidate = candidate;
                continue;
            }
            if (bestCandidate.length() <= candidate.length()) continue;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    static String findFolderPath(Folder root, String prefix) {
        for (Object o : root.getElements()) {
            int j;
            if (!(o instanceof Item)) continue;
            Item i = (Item)o;
            String path = i.getAbsPath();
            if (prefix.isEmpty() || (j = (path = path.replace('\\', '/')).indexOf(prefix + "/")) < 0) continue;
            return path.substring(0, j);
        }
        for (Object o : root.getElements()) {
            Folder f;
            String res;
            if (!(o instanceof Folder) || (res = ImportExecutable.findFolderPath(f = (Folder)o, prefix + "/" + f.getName())) == null) continue;
            if (prefix.isEmpty()) {
                return res + "/" + f.getName();
            }
            return res;
        }
        return null;
    }

    private static final class DiscoveredConfigure {
        private File script;
        private int scriptWeight;
        private File makefile;
        private int makefileWeight;

        private DiscoveredConfigure() {
        }

        private void setScript(File script, int weight) {
            if (this.script == null || this.scriptWeight < weight) {
                this.script = script;
                this.scriptWeight = weight;
            }
        }

        private void setMakefile(File makefile, int weight) {
            if (this.makefile == null || this.makefileWeight < weight) {
                this.makefile = makefile;
                this.makefileWeight = weight;
            }
        }
    }
}

