/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbPreferences;

public class FileChooser
extends JFileChooser {
    private static File currentChooserFile = null;

    public FileChooser(String titleText, String buttonText, int mode, FileFilter[] filters, String feedFilePath, boolean useParent) {
        super(FileChooser.computeCurrentDir(feedFilePath, useParent));
        this.setFileHidingEnabled(false);
        this.setFileSelectionMode(mode);
        this.setDialogTitle(titleText);
        if (buttonText != null) {
            this.setApproveButtonText(buttonText);
        }
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                this.addChoosableFileFilter(filters[i]);
            }
            this.setFileFilter(filters[0]);
        }
        File parent = this.getCurrentDirectory();
        File file = FileChooser.getCurrentChooserFile();
        if (parent != null && file != null && parent.equals(file.getParentFile())) {
            this.setSelectedFile(file);
        }
    }

    private static File computeCurrentDir(String feedFilePath, boolean useParent) {
        File feedFilePathFile = null;
        if (feedFilePath != null && feedFilePath.length() > 0) {
            feedFilePathFile = new File(feedFilePath);
            try {
                feedFilePathFile = feedFilePathFile.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (feedFilePathFile != null && feedFilePathFile.exists()) {
            FileChooser.setCurrentChooserFile(feedFilePathFile);
        }
        if (FileChooser.getCurrentChooserFile() == null && feedFilePathFile == null) {
            feedFilePathFile = new File(FileChooser.getLastPath());
        }
        if (FileChooser.getCurrentChooserFile() == null && feedFilePathFile.getParentFile() != null && feedFilePathFile.getParentFile().exists()) {
            FileChooser.setCurrentChooserFile(feedFilePathFile.getParentFile());
            useParent = false;
        }
        if (FileChooser.getCurrentChooserFile() != null) {
            if (useParent) {
                if (FileChooser.getCurrentChooserFile() != null && FileChooser.getCurrentChooserFile().exists()) {
                    return FileChooser.getCurrentChooserFile().getParentFile();
                }
            } else if (FileChooser.getCurrentChooserFile() != null && FileChooser.getCurrentChooserFile().exists()) {
                return FileChooser.getCurrentChooserFile();
            }
        } else {
            File sdFile;
            String sd = System.getProperty("spro.pwd");
            if (sd != null && (sdFile = new File(sd)).exists()) {
                return sdFile;
            }
        }
        return null;
    }

    private static String getLastPath() {
        Preferences pref;
        String res;
        File file;
        String feed = System.getProperty("user.home");
        if (feed == null) {
            feed = "";
        }
        if (!(file = new File(res = (pref = NbPreferences.forModule(FileChooser.class)).get("last-file", feed))).exists() && !res.equals(feed)) {
            res = feed;
        }
        return res;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int ret = super.showOpenDialog(parent);
        if (ret != 1 && this.getSelectedFile().exists()) {
            FileChooser.setCurrentChooserFile(this.getSelectedFile());
            Preferences pref = NbPreferences.forModule(FileChooser.class);
            pref.put("last-file", FileChooser.getCurrentChooserFile().getAbsolutePath());
        }
        return ret;
    }

    public static File getCurrentChooserFile() {
        return currentChooserFile;
    }

    public static void setCurrentChooserFile(File aCurrentChooserFile) {
        currentChooserFile = aCurrentChooserFile;
    }
}

